#import "grid.h"
#import <activity.h>
#import <objectbase.h>
#import <defobj/DefObject.h>      // for dropAllocations: of internal actions
#import <activity/SwarmProcess.h> // activate:

#include <misc.h>

static void terminateFunction( void )
{
  [getTopLevelActivity() terminate];
}

static void nestedFunction( void )
{
  char buf1[100], buf2[100];

  _obj_formatIDString( buf1, getTopLevelActivity() );
  _obj_formatIDString( buf2, [getTopLevelActivity() getControllingActivity] );

  printf( "top level activity: %s\ncontrolling activity: %s\n", buf1, buf2 );
}

static void runFunction( void )
{
  id  group, groupActivity;

  group = [ActionGroup create: globalZone];
  [group createActionCall: (func_t)printf : (id)"nested group performed\n"];
  [group createActionCall: nestedFunction];
  groupActivity = [group activateIn: nil];
  [groupActivity run];
  [groupActivity drop];
  [group drop];
}

int main(void)
{
  id  x, aZone, sched1, sched2, action1, action2;
  id  swarm;
  id  <Activity>swarmActivity;
  id  <Symbol>status;

  initModule( grid );
  initModule( activity );

  aZone = [Zone create: globalZone];
  swarm = [Swarm create: aZone];
  _activity_zone = [Zone create: globalZone];

  sched1 = [Schedule create: swarm];
  [sched1 at: 1 createActionCall: terminateFunction];

  x = [Schedule createBegin: swarm];
  [x setRepeatInterval: 10];
  sched2 = [x createEnd];

  [sched2 createActionCall: (func_t)printf :
    (id)"repeating action performed\n"];
  [sched2 createActionCall: (func_t)runFunction];

  // create a concurrent group just to make sure it goes away

  action1 = [sched2 at: 1 createActionCall: (func_t)printf : (id)"action 1\n"];
  action2 = [sched2 at: 1 createActionCall: (func_t)printf : (id)"action 2\n"];

  [sched2 remove: action1];
  [sched2 remove: action2];

  swarmActivity = [swarm activateIn: nil];
  [swarm activate: sched1];
  [swarm activate: sched2];

  while ( (status = [swarmActivity run]) != Stopped  && (status != Completed) );

  [swarmActivity drop];
  [_activity_zone xprint];

#if 0
  [sched1 drop];
  [sched2 drop];
#endif
  [action1 drop];
  [action2 drop];
  [[swarm getInternalZone] xprint];

  [swarm drop];
  [aZone xprint];
  return 0;
}
