#import "Mousetrap.h"
#import <objectbase.h>

#include <misc.h>

int gridSize              = 40;
int printTriggerEvents    = 1;
int printSameTickTriggers = 0;


// simulation parameters (these need to be a power of 2)

int triggerLikelihood    = 256;
int numberOutputTriggers = 2;
int maxTriggerDistance   = 4;
int maxTriggerTime       = 16;

// data from the mousetrap world

unsigned numTriggered = 0;

id grid, worldSchedule;

static void testTerminate( void )
{
  if ( ! [worldSchedule getCount] ) [getTopLevelActivity() terminate];
}

int main(int argc, char ** argv)
{
  id   aMousetrap, worldSwarm;
  id   displaySchedule, observerSwarm, observerActivity, status;
  int  x, y, stepCount;

  initModule( activity );

  observerSwarm = [Swarm create: globalZone];
  worldSwarm = [Swarm create: observerSwarm];
  _activity_zone = [Zone create: globalZone];

  // put a mousetrap on every grid point

  grid = [Grid2D create: worldSwarm setGridSize: gridSize];
  for ( y = 0; y < gridSize; y ++ ) {
    for ( x = 0; x < gridSize; x++ ) {
      aMousetrap = [Mousetrap create: worldSwarm setXCoord: x setYCoord: y];
      [grid atX: x atY: y put: aMousetrap];
    }
  }

  // create the mousetrap world schedule and schedule its first action

  worldSchedule = [Schedule createBegin: worldSwarm];
  [worldSchedule setAutoDrop: 1];
  worldSchedule = [worldSchedule createEnd];

  aMousetrap = [grid atX: gridSize/2 atY: gridSize/2];
  [worldSchedule at: 0 createActionTo: aMousetrap message: M(trigger)];

  // create display schedule and schedule the display events

  displaySchedule = [Schedule createBegin: observerSwarm];
  [displaySchedule setRepeatInterval: 10];
  displaySchedule = [displaySchedule createEnd];

  [displaySchedule at: 0 createActionTo:
    [grid atX: (gridSize + gridSize/2)/(gridSize/2) atY: gridSize/2]
    message: M(printTriggered)];
  [displaySchedule at: 0 createActionCall: (func_t)testTerminate];

  // create a swarm to combine the display schedule and the world swarm

  observerActivity = [observerSwarm activateIn: nil];
  [displaySchedule activateIn: observerSwarm];

  [worldSwarm activateIn: observerSwarm];
  [worldSchedule activateIn: worldSwarm];

  // [observerActivity run];

  status = [observerActivity stepUntil: 12];
  printf( "returned from stepUntil: 12 with status %s\n", [status getName] );
  status = [observerActivity stepUntil: 2];
  printf( "returned from stepUntil: 2 with status %s\n", [status getName] );

  for ( stepCount = 0; [observerActivity step] == Stopped; stepCount++ );
  printf( "number of steps: %d\n", stepCount );
  printf( "total number of mousetraps triggered: %d\n", numTriggered );
  return 0;
}
