#import "grid.h"

#define __USE_FIXED_PROTOTYPES__   // for gcc headers
#include <stdio.h>

int main(void)
{
  id   aZone, anArray, newArray, aTurtle, aMember, index;
  int  i;
  
  initModule( grid );

  aZone = [Zone create: globalZone];

  anArray = [Array create: aZone setCount: 12];

  printf( "count: %d\n", [anArray getCount] );

  for ( i = 0; i < 10; i++ ) {
    aTurtle = [GridTurtle create: aZone];
    [aTurtle turn: -1];
    [aTurtle move: i * 10];
    [anArray atOffset: i put: aTurtle];
  }

  printf( "count: %d\n", [anArray getCount] );

  index = [anArray begin: scratchZone];
  while ( (aMember = [index next]) || [index getLoc] != End ) {
    if ( ! aMember ) {
      printf( "member is nil\n" );
    } else if ( [aMember respondsTo: M(print)] ) {
      [aMember print];
    } else {
      printf( "%s\n", [aMember getName] );
    }
  }
  while ( (aMember = [index prev]) || [index getLoc] != Start ) {
    if ( ! aMember ) {
      printf( "member is nil\n" );
    } else if ( [aMember respondsTo: M(print)] ) {
      [aMember print];
    } else {
      printf( "%s\n", [aMember getName] );
    }
  }

  [anArray setCount: 15];
  index = [anArray begin: scratchZone];
  while ( (aMember = [index next]) || [index getLoc] != End ) {
    if ( ! aMember ) {
      printf( "member is nil\n" );
    } else if ( [aMember respondsTo: M(print)] ) {
      [aMember print];
    } else {
      printf( "%s\n", [aMember getName] );
    }
  }
  [index setLoc: Start];

  [anArray setCount: 8];
  index = [anArray begin: scratchZone];
  while ( (aMember = [index next]) || [index getLoc] != End ) {
    if ( ! aMember ) {
      printf( "member is nil\n" );
    } else if ( [aMember respondsTo: M(print)] ) {
      [aMember print];
    } else {
      printf( "%s\n", [aMember getName] );
    }
  }

  [anArray atOffset: 2 put: nil];
  newArray = [anArray copy: aZone];

  index = [newArray begin: scratchZone];
  [newArray atOffset: 3 put: nil];
  while ( (aMember = [index next]) || [index getLoc] != End ) {
    if ( ! aMember ) {
      printf( "member is nil\n" );
    } else if ( [aMember respondsTo: M(print)] ) {
      [aMember print];
    } else {
      printf( "%s\n", [aMember getName] );
    }
  }
  [newArray drop];

  [anArray atOffset: 5 put: nil];
  newArray = [Array createBegin: aZone];
  [newArray setInitialValue: anArray];
  newArray = [newArray createEnd];
  [newArray atOffset: 6 put: nil];

  index = [newArray begin: scratchZone];
  while ( (aMember = [index next]) || [index getLoc] != End ) {
    if ( ! aMember ) {
      printf( "member is nil\n" );
    } else if ( [aMember respondsTo: M(print)] ) {
      [aMember print];
    } else {
      printf( "%s\n", [aMember getName] );
    }
  }
  [index drop];

  index = [anArray begin: scratchZone];
  while ( (aMember = [index next]) || [index getLoc] != End ) {
    if ( ! aMember ) {
      printf( "member is nil\n" );
    } else if ( [aMember respondsTo: M(print)] ) {
      [aMember print];
    } else {
      printf( "%s\n", [aMember getName] );
    }
  }

  for ( i = 0; i < 8; i++ ) {
    aMember = [anArray atOffset: i];
    if ( ! aMember ) {
      printf( "member is nil\n" );
    } else if ( [aMember respondsTo: M(print)] ) {
      [aMember print];
    } else {
      printf( "%s\n", [aMember getName] );
    }
  }
  [anArray xprint];
  [aZone xprint];
  [anArray drop];
  [newArray drop];
  [aZone xprint];
  [aZone xfprint];
  [aZone drop];
  exit(0);
}
