// Swarm library.
// Copyright  1996  by the Regents of the University of Michigan.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// object to shuffle Swarm List list with num elts, in place
// from Knuth vol 2

// Modified by Nelson Minar <nelson@media.mit.edu> from Ted Belding's code.
// Changed the random number distribution used.
//   Sun Jul  6 22:42:35 MET DST 1997

#import "Shuffler.h"
#import <simtools.h>

// Defining the methods for a agent.
@implementation Shuffler

// Initialize world for the agent.
-setUniformRandom: (id) rnd {
  // Strictly speaking, this check isn't necessary. But we intend these
  // parameters to be immutable once set, so to be extrasafe we check:
  // it could catch an error later.
  if (uniformRandom != nil) {
    [InvalidArgument raiseEvent: "You can only set the random number
generator of the shuffler at creation time\n"];
  }
  uniformRandom = rnd;
  return self;
}

-createEnd {
  if (uniformRandom == nil) {
    [InvalidCombination raiseEvent: "shuffler was created without a random
number generator.\n"];
  }
  return self;					  // CRUCIAL!
}

-shuffleList: list {
  // shuffle Swarm List list with num elts, in place
  // from Knuth vol 2
  
  int j, k;
  id temp;
  
  j = [list getCount];
  
  while (j > 1) {
    k = [uniformRandom getIntegerWithMin: 0 withMax: j-1];
    j--;
    temp = [list atOffset: k];
    [list atOffset: k put: [list atOffset: j]];
    [list atOffset: j put: temp];
  }
  return self;
}

@end
