// Hello, World! application. Copyright (C) 1996-1998 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// peculiar to gcc when including some of the header files
#define __USE_FIXED_PROTOTYPES__
#include <math.h>
#import <simtools.h>
#import "PplModelSwarm.h"

// declare the neighborhood to use
VNneighbor * vnneighbor;

// Implementation of the model for ppl.

@implementation PplModelSwarm

- getPplList
{
  return pplList;
}

- (Counter *)getCounter
{
  return counter;
}

- (DiscreteToroid *)getWorld
{
  return room;
}

+ createBegin: aZone
{
  PplModelSwarm * obj;
  id <ProbeMap> probeMap;

  obj = [super createBegin: aZone];

  // MODIFY: add in defaults for your simulation parameters.
  obj->increment = 1;

  // default number of people
  obj->numPpl = 10;
  // default modifyable space attributes
  obj->worldXSize = 15;
  obj->worldYSize = 15;
  obj->doorX = 0;
  obj->doorY = 0;
  obj->displayConversations = 0; // don't display them by default

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  // Add probe to tell how often to increment the counter
  [probeMap addProbe: [probeLibrary getProbeForVariable: "increment"
				    inClass: [self class]]];
  // add probe to set number of people
  [probeMap addProbe: [probeLibrary getProbeForVariable: "numPpl"
                                    inClass: [self class]]];

  // add probe for space attributes
  [probeMap addProbe: [probeLibrary getProbeForVariable: "worldXSize"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "worldYSize"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "doorX"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "doorY"
				    inClass: [self class]]];

  // add probe whether or not to show conversations
  [probeMap addProbe: [probeLibrary getProbeForVariable: "displayConversations"
				    inClass: [self class]]];

  // install probemap into the library
  [probeLibrary setProbeMap: probeMap For: [self class]];
  
  return obj;
}

// MODIFY: possible creation objects here.
- createEnd
{
  return [super createEnd];
}

- buildObjects
{
  int inci, incj;

  [super buildObjects];

  // MODIFY: create your simulation objects and set them up from the
  // model parameters.
  counter = [Counter create: [self getZone]];
  [counter setIncr: increment];

  // Create a VNneighbor: used for initialisation stuff, and
  // shared among all the people also.
  vnneighbor = [VNneighbor create: [self getZone]];

  // set up the room used to represent persons position
  room = [DiscreteToroid createBegin: [self getZone]];

  [room setSizeX: worldXSize Y: worldYSize];
  room = [room createEnd];

  // build the list to keep track of the ppl
  pplList = [List create: [self getZone]];

  // build the ppl
  for (inci = 0; inci < numPpl; inci++)
    {
      Person * person;
      id name;
      float topics[2];
      int namesize;
      Color color;
      int tempX, tempY;            //temp x,y coordinates
      int radius, theta;           // temporary vars used for init distrib of ppl

      // Linux Note!  For some reason, unless this is a full 32-bit
      //        variable, control characters get mixed up in 
      //        the chars as they are added to the name
      //        I suspect that when the String object gets its
      //        zone, that zone is not cleared.  Since everything
      //        is added to the string by address and chars are 8-bits
      //        the setC and appendC have to be smart enough to throw
      //        away the part of the word that isn't relevant.
      //        Must be an endian problem.
#ifdef linux
      int temp_char; 
#else
      char temp_char;
#endif

      // allocate memory for a temporary person
      person = [Person createBegin: [self getZone]];

      // come up with a name
      namesize = [uniformIntRand getIntegerWithMin: 2L withMax: 4L];

      // initialize and create the name
      temp_char = [uniformIntRand getIntegerWithMin: 'A' withMax:'Z'];
      name = [String createBegin: [person getZone] ];
      [name setC: (char *) &temp_char];
      name = [name createEnd];

      // then finish the name
      for (incj = 1; incj <= namesize; incj++)
        {
          temp_char = [uniformIntRand getIntegerWithMin:'a' withMax:'z'];
          [name appendC: (char *) &temp_char];
        }

      // the null topic is how undesirable communication is for this person
      topics[null] = 0.0;
      // hello is the only thing to say for now
      topics[hello] = 1.0;

      // generate a color for her
      color = (Color) [uniformUnsRand getUnsignedWithMin: 1L withMax: 124L];
      [person setPersonColor: color];

      // tell the person what her comm numbers are
      [person setPerson: name Topic_array: topics ShowSpeech: displayConversations];
      // tell the person where she is
      [person setWorld: pplList Room: room Party: self];

      // Let's try to make it as if they all entered from one door
      // and kind of fanned out through the room.
      do {
        radius = [uniformIntRand 
                   getIntegerWithMin: 1L withMax: (worldXSize -1)];
        theta  = [uniformIntRand getIntegerWithMin: 0L withMax: 359L];

        tempX = (int) floor (radius * cos (theta * 3.14159/180.)) + doorX;
        tempY = (int) floor (radius * sin (theta * 3.14159/180.)) + doorY;

      }
      // check to see if that position is already occupado
      while (([room getObjectAtX: tempX Y: tempY] != nil));

      [person unwarpToX: tempX Y: tempY];

      // re-allocate the person and finish the create phase
      person = [person createEnd];

      // add the person to the list of people
      [pplList addLast: person];

    }
  return self;
}

- buildActions
{
  [super buildActions];

  // create an action group to delineate the events
  modelActions = [ActionGroup create: [self getZone]];
  // Create an action to send a message to the counter every cycle
  //    telling it to execute "step"
  [modelActions createActionTo: counter message: M(step)];
  // Create an action to send a message to each member of pplList
  //    every cycle telling them to execute "step"
  [modelActions createActionForEach: pplList message: M(step)];

  // Create a schedule for the events in modelActions
  modelSchedule = [Schedule createBegin: [self getZone]];
  // tell the model schedule to do the same thing at each time step
  [modelSchedule setRepeatInterval: 1];
  // re-allocate the modelSchedule and finish create phase
  modelSchedule = [modelSchedule createEnd];
  // tell the schedule to start doing the events in modelActions 
  //    at time 0  (the setRepeatInterval ensures that it happens
  //    again at time 1, 2, 3, ...)
  [modelSchedule at: 0 createAction: modelActions];

  return self;
}

- activateIn: swarmContext
{

  // the modelswarm will have a number of people talking
  // initialize it right before activating the model swarm
  numberPplStillTalking = numPpl;

  // send a message to our super activating ourselves in their schedule
  [super activateIn: swarmContext];
  // then send a message to our schedule to start our actions
  [modelSchedule activateIn: self];
  // pass back the SwarmActitivity in the queue
  return [self getSwarmActivity];
}

// the objects will call this when they're done talking
- ImFinished
{
  numberPplStillTalking--;
  return self;
}

// the observer will call this to find out when to quit
- (int)getNumberPplStillTalking 
{
  return numberPplStillTalking;
}
@end

