// Hello, World! application. Copyright (C) 1996-1998 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import <objectbase.h>
#import <simtools/GUISwarm.h>
#import <analysis.h>
#import "PplModelSwarm.h"

// Sample graphical interface swarm for models.
@interface PplObserverSwarm : GUISwarm
{
  int displayFrequency;

  id displayActions;
  id displaySchedule;

  // add the modelswarm to the observer swarm
  PplModelSwarm * pplModelSwarm;
  // add the counter to the observer swarm
  Counter * observedCounter;

  // add the numberPplStillTalking graph to obs swarm
  BLTGraph * pplLeftGraph;
  GraphElement * numberLeft;
  ActiveGraph  * pplLeftGrapher;

  // add the number of friends averager
  EZGraph * avgFriendGraph;

  // add the space viewer objects
  XColormap * colormap;
  ZoomRaster * worldRaster;
  Object2dDisplay * pplDisplay;
}

+createBegin: (id) aZone;
-createEnd;
-buildObjects;
-buildActions;
-activateIn: (id) swarmContext;

// checks to see if everybody's done talking
-checkToStop;

@end
