// Market application. Copyright (C) 1996-1998 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/* Copyright (C) 1995 The Santa Fe Institute. */
/* No warranty implied, see LICENSE for terms. */

/* -------------------    Include Files and Definitions		--------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#import <simtools.h>
#ifdef LIBCRANDOM
#define RANDOM		(random() % 10001)/10000.0			/*  Random number between 0 and 1		*/
#else
#define RANDOM ((float)[uniformDblRand getDoubleWithMin: 0.0L withMax: 1.0L])
#endif




/* -------------------	Experiment Parameters			----------------------------*/

#define TOTPREDICTORS 			16				/*	Total possible predictors			*/
#define TOTPERSONS 				100				/*	Total agents 						*/
#define HISTORY_LENGTH			12				/*	Past days kept for predictors		*/
#define EXPT_LENGTH				500			/*	Number of days of trading		 	*/
#ifdef LIBCRANDOM
#define INITIAL_HIST			200.0 + (float) (random() % 41)
#else
#define INITIAL_HIST                    200.0 + (float) ([uniformDblRand getDoubleWithMin: 0.0L withMax: 41.0L])
#endif
#define NOISE_TRADERS			0				/*  Number of noise traders				*/
#define FUNDAMENTAL_TRADERS 	0				/*	Number using fundamentals			*/
#define	FUNDAMENTAL_VALUE		0.0
#define NOISE_PREDICTION		0.0
#define NEED_TO_REPORT			day%1 ==0		/*	Interval for writing reports		*/

extern int   MAXHEED;		/* Total predictors each agent notices	*/
extern double ETA;		/* Rate for updating predictor accurs. */
extern double BETA;		/* Discount rate */
extern double NU;		/* Multiplier for dividend jumps */			extern double INITIAL_DIVIDEND;

/* -------------------	Structure Definitions			----------------------------*/

typedef struct	{				/* Each prediction contains a forecast and accuracy	*/
				float numbers;
				double accuracy;
				int rank;
				int flag;
} prediction;

typedef struct {					/* Each person heeds an array of predictors		*/
				int heed[TOTPREDICTORS];/* chooses a forecaster, decides to go or not	*/
				int forecaster;
} hombre;

/* ------------------------------------------------------------------------------------*/

