// Hello, World! application. Copyright (C) 1996-1998 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.
// This is the method definitions file for the Person agents.

// include person header so that everything will be defined
#import "Person.h"
#import "PplModelSwarm.h"
#define VNSet 4

#import <random.h>

@implementation Person

- step
{
  neighbor_t newNeigh;
  int newX, newY;
  int gotOne = 0, inci;

  value += 1;

  // "Should I stay or should I go, now?" 
  if (!strcmp([self stayOrGo], "stay")) {
    stillhere = 1;

    // look for a place to move
    //  initialize the choice of direction to move to randomly
    //    choose integer from 1 to number of directions in the set
    newNeigh = (neighbor_t) [uniformUnsRand 
			      getUnsignedWithMin: 1L withMax: VNSet]; 
    //  starting at that direction, move around the neighborhood until we
    //    find an empty spot to move to, else don't move
    for (inci=0; inci < VNSet; inci++) {
      // if we found an empty one, exit the loop
      if ([self getAgentAtNeighbor: newNeigh] == nil) {
	gotOne = 1;
	break;
      }
      // increment neighborhood
      newNeigh = [vnneighbor next: newNeigh];
    }

    // if we found a space to move to, then move
    if (gotOne) {
      newX = [self getNeighborX: newNeigh];
      newY = [self getNeighborY: newNeigh];
      [self warp];
      [self unwarpToX: newX Y: newY];
      // take a look around and speak if you find someone
      if ((target = [self look]) != nil) {
	// say hello
	[self speak: hello ToPerson: target];
	// add them to my list of friends
	[listOfFriends addLast: target];
      }
    }  // else don't do anything
  }
  else {
    stillhere = 0;
    [self setPersonColor: 125];
  }
  return self;
}

- setWorld: l Room: r Party: m
{
  pplPresent = l;   // set a pointer inside each party-goer to the list of partiers
  world = room = r;    // set a pointer back to the space we're in
  party = m;   // set a pointer inside each party-goer for the id of the party
  return self;
}

- setPerson: n  Topic_array: (float *)t ShowSpeech: (int)sp
{
  int i;

  name = n;
  value = 0;
  for (i=0;i<2;i++)
    topics[i] = t[i];
  stillhere = 1;   // always here when initialized
  showSpeech = sp;  // display the speech (0 by default)
  return self;
}

// set color
- setPersonColor: (Color)c
{
  myColor = c;
  return self;
}

- createEnd
{
  // create an empty list in which to put the people you will talk to
  listOfFriends = [List create: [self getZone]];
  approachingTarget = 0;
  // do the super's createEnd for switcheroo (not strictly necessary)
  [super createEnd];
  return self;
}

- print
{
  int inci;

  (void) printf("\t Step value = %d\n", value);
  (void) printf("%s%f\n%s%f\n",
		"\t              topics[null] = ", topics[null],
		"\t             topics[hello] = ", topics[hello]);

  (void) printf("\tMy name is %s\n",[self getName]);
  (void) printf("\t\tMy Embedded flag = %d\n", [self getEmbedded]);
  (void) printf("\t\tMy list of friends is %d long:\n",
		[listOfFriends getCount]);
  for (inci=0;inci<[listOfFriends getCount]; inci++)
     (void) printf("\t\t\t%s\n",[[listOfFriends atOffset: inci] getName]);


  return self;
}

- (const char *)getName
{
  return [name getC];
}

- speak: (topic_type)topic ToPerson: person
{
  float new_topic_num;
  // topic can be null
  new_topic_num = (float)[uniformDblRand getDoubleWithMin: 0.0L withMax: 1.0L];

  if (showSpeech) {

    if (new_topic_num < topics[null])
      (void) printf("Prefer to talk about nothing with ");
    else if (new_topic_num < topics[hello])
      (void) printf("%s says Hello, ", [self getName]);
    else {
      (void) fprintf(stderr,"Exception in random topic draw.\n");
      exit(-1);
    }

    (void) printf(" to %5s.\n", [person getName]);
  }
  return self;
}

- (Person *)look
{
  id tgt;
  id indx;         // index for persons
  int numfriends, inci, incj, talked = 0;
  neighbor_t newNeigh;

  // look around the neighborhood and see if there's anybody here
  //   I haven't talked to

  // start at some random direction
  newNeigh = (neighbor_t) [uniformUnsRand 
			    getUnsignedWithMin: 1L withMax: VNSet];
  // loop around all directions, if you find someone, pass her back
  //   to the step method
  for (inci=0; inci < VNSet; inci++) {
    // reset talked to zero for the next neighbor
    talked = 0;
    if ((tgt = [self getAgentAtNeighbor: newNeigh]) != nil) {
      // decide if you've already talked to that person
      // if the count is > zero, there are friends in the list
      if ((numfriends = [listOfFriends getCount]) > 0) {
	// loop through the people we've talked to already
	for (incj = 0; incj < numfriends; incj++) {
	  // linked list elements accessed via an offset from 0
	  indx = [listOfFriends atOffset: incj];
	  // if this friend's id is the same as my tgt's id, then
	  // I've already talked to her
	  if (tgt == indx)
	    talked = 1;
	}  // end of loop over friends

	// if we didn't find her in our list, then break
	//  and pass her id back
	if (!talked) break;

      }  // end of empty list if
    }  // end of tgt assignment
    newNeigh = [vnneighbor next: newNeigh];
  }  // end of for loop over neighborhoods

  // reset tgt to nil in case we've talked to the last neighbor
  if (talked) {
    tgt = nil;
  }

  // return the successful sighting
  return tgt;
}

// this method makes the decision to stay or leave the party
- (const char *)stayOrGo
{
  if (stillhere) {
    // see if you've talked to everybody except yourself
    if (([pplPresent getCount] - 1) <= [listOfFriends getCount]) {
      stillhere = 0;
      // tell the host that i'm taking myself out
      [party ImFinished];
    }
  }
  return (stillhere == 1 ? "stay" : "gone");
}

// provide a method to extract the number of people talked to
- (int)getNumFriends
{
  return [listOfFriends getCount];
}

// this method sends a message to the raster telling it to place
//   me on it with my color
- drawSelfOn: (id <Raster>)rast
{
  [rast drawPointX: x Y: y Color: myColor];
  return self;
}

@end
