// Market application. Copyright (C) 1996-1998 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import "MarketModelSwarm.h"
#import <simtoolsgui/GUISwarm.h>
#import <simtoolsgui.h>
#import <gui.h>

// Sample graphical interface swarm for models.
@interface MarketObserverSwarm: GUISwarm
{
  int displayFrequency;

  id displayActions;
  id displaySchedule;

  MarketModelSwarm *marketModelSwarm;

  id <Graph> priceGraph;
  id <GraphElement> priceElement, dividendElement, fundamentalElement;
  id <ActiveGraph> priceGrapher, dividendGrapher, fundamentalGrapher;
  id <Histogram> useHisto;
}

+ createBegin: aZone;
- buildObjects;
- buildActions;
- activateIn: swarmContext;

@end
