// Hello, World! application. Copyright (C) 1996-1998 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// This is the method definitions file for the Person agents.

#import <random.h>
// include person header so that everything will be defined
#import "Person.h"

@implementation Person

- step
{
  value += 1;
  [self look];
  return self;
}

- setWorld: l
{
  world = l;
  return self;
}

- setPerson: n Topic_array: (float *)t
{
  int i;

  name = n;
  value = 0;
  for (i= 0;i < 2; i++)
    topics[i] = t[i];
  return self;
}

- print
{
  (void) printf("\t Step value = %d\n", value);
  (void) printf ("%s%f\n%s%f\n",
                 "\t              topics[null] = ", topics[null],
                 "\t             topics[hello] = ", topics[hello]);
  
  return self;
}

- (const char *)getName
{
  return [name getC];
}

- speak: (topic_type)topic ToPerson: person
{
  float new_topic_num;
  // topic can be null
  new_topic_num = (float)[uniformDblRand getDoubleWithMin: 0.0L withMax: 1.0L];

  if (new_topic_num < topics[null])
    (void)printf("Prefer to talk about nothing with ");
  else if (new_topic_num < topics[hello])
    (void)printf("%s says Hello, ", [self getName]);
  else 
    {
      (void) fprintf(stderr,"Exception in random topic draw.\n");
      exit(-1);
    }
  
  (void)printf(" to %5s.\n", [person getName]);
  
  return self;
}

- look
{
  id target;
  // since world is a list, the atOffset method will work
  target = [world atOffset: [uniformIntRand 
			      getIntegerWithMin: 1L 
			      withMax: ([world getCount]-1)]];
  
  [self speak: hello ToPerson: target];
  return self;
}
@end
