// Hello, World! application. Copyright (C) 1996-1998 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import <simtoolsgui/GUISwarm.h>
#import <simtoolsgui.h>
#import <gui.h>
#import <analysis.h> // ActiveGraph
#import "PplModelSwarm.h"

// Sample graphical interface swarm for models.
@interface PplObserverSwarm: GUISwarm
{
  int displayFrequency;

  id displayActions;
  id displaySchedule;

  // add the modelswarm to the observer swarm
  PplModelSwarm *pplModelSwarm;
  // add the counter to the observer swarm
  Counter *observedCounter;
  // add the numberPplStillTalking graph to obs swarm
  id <Graph> pplLeftGraph;
  id <GraphElement> numberLeft;
  id <ActiveGraph> pplLeftGrapher;
}

+ createBegin: aZone;
- createEnd;
- buildObjects;
- buildActions;
- activateIn: swarmContext;

// checks to see if everybody's done talking
- checkToStop;

@end
