// Market application. Copyright (C) 1996-1998 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import "global.h"
#import "define.h"
#import "extern.h"
#import "MarketObserverSwarm.h"
#import <gui.h>

static const char *predictorColors[] = {
  "red", "orange", "yellow", "green", "blue", "purple", "grey50", "black",
  "red", "orange", "yellow", "green", "blue", "purple", "grey50", "black"
};
static unsigned numPredictorsToShow = 7;

// implementation of sample graphical interface for models.
@implementation MarketObserverSwarm

+ createBegin: aZone
{
  MarketObserverSwarm * obj;
  id <ProbeMap> probeMap;
  
  obj = [super createBegin: aZone];

  obj->displayFrequency = 1;

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  [probeMap addProbe: [probeLibrary getProbeForVariable: "displayFrequency"
				    inClass: [self class]]];

  [probeLibrary setProbeMap: probeMap For: [self class]];

  return obj;
}

- _histogramDeath_ : caller
{
  [useHisto drop];
  useHisto = nil;
  return self;
}

- buildObjects
{
  id modelZone;

  [super buildObjects];
  
  modelZone = [Zone create: [self getZone]];
  marketModelSwarm = [MarketModelSwarm create: modelZone];
  
  CREATE_ARCHIVED_PROBE_DISPLAY (marketModelSwarm);
  CREATE_ARCHIVED_PROBE_DISPLAY (self);

  [actionCache waitForControlEvent];
  if ([controlPanel getState] == ControlStateQuit)
    return self;

  [marketModelSwarm buildObjects];

  // turn off stdio printing.
  pr_text = 0;
  
  // create graph for price of commodity
  priceGraph = [Graph createBegin: globalZone];
  SET_WINDOW_GEOMETRY_RECORD_NAME (priceGraph);
  priceGraph = [priceGraph createEnd];
  [priceGraph setTitle: "Price of commodity vs. time"];
  [priceGraph setAxisLabelsX: "time" Y: "price"];
  [priceGraph setWidth: 400 Height: 250];
  [priceGraph pack];
  [priceGraph setScaleModeX: 1 Y: 0];

  // create three elements to draw on that graph.
  priceElement = [priceGraph createElement];
  [[[priceElement setLabel: "price"] setColor: "red"] setWidth: 3];
  priceGrapher = [ActiveGraph createBegin: [self getZone]];
  [priceGrapher setElement: priceElement];
  [priceGrapher setDataFeed: marketModelSwarm];
  [priceGrapher setProbedSelector: M(getPrice)];
  priceGrapher = [priceGrapher createEnd];

  dividendElement = [priceGraph createElement];
  [[dividendElement setLabel: "dividend"] setColor: "black"];
  dividendGrapher = [ActiveGraph createBegin: [self getZone]];
  [dividendGrapher setElement: dividendElement];
  [dividendGrapher setDataFeed: marketModelSwarm];
  [dividendGrapher setProbedSelector: M(getDividend)];
  dividendGrapher = [dividendGrapher createEnd];

  fundamentalElement = [priceGraph createElement];
  [[fundamentalElement setLabel: "fundamental"] setColor: "blue"];
  fundamentalGrapher = [ActiveGraph createBegin: [self getZone]];
  [fundamentalGrapher setElement: fundamentalElement];
  [fundamentalGrapher setDataFeed: marketModelSwarm];
  [fundamentalGrapher setProbedSelector: M(getFundamental)];
  fundamentalGrapher = [fundamentalGrapher createEnd];
  
  useHisto = [Histogram createBegin: globalZone];
  SET_WINDOW_GEOMETRY_RECORD_NAME (useHisto);
  [useHisto setNumBins: numPredictorsToShow];
  useHisto = [useHisto createEnd];

  [useHisto enableDestroyNotification: self
            notificationMethod: @selector(_histogramDeath_:)];

  [useHisto setWidth: 400 Height: 250];
  [useHisto setLabels: pred count: numPredictorsToShow];
  [useHisto setColors: predictorColors count: numPredictorsToShow];
  [useHisto setTitle: "Usage of predictors"];
  [useHisto setAxisLabelsX: "predictor index" Y: "usage of predictor"];
  [useHisto pack];
  
  return self;
}  

- buildActions
{
  [super buildActions];
  
  [marketModelSwarm buildActions];

  displayActions = [ActionGroup create: [self getZone]];
  [displayActions createActionTo: priceGrapher        message: M(step)];
  [displayActions createActionTo: dividendGrapher     message: M(step)];
  [displayActions createActionTo: fundamentalGrapher  message: M(step)];
  [displayActions createActionTo: self                message: M(updateHisto)];
  [displayActions createActionTo: probeDisplayManager message: M(update)];
  [displayActions createActionTo: actionCache         message: M(doTkEvents)];

  displaySchedule = [Schedule createBegin: [self getZone]];
  [displaySchedule setRepeatInterval: displayFrequency];
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule at: 0 createAction: displayActions];

  return self;
}  

- activateIn: swarmContext
{
  [super activateIn: swarmContext];

  [marketModelSwarm activateIn: self];
  [displaySchedule activateIn: self];
  
  return [self getSwarmActivity];
}

- updateHisto
{
  if (useHisto)
    [useHisto drawHistogramWithInt: [marketModelSwarm getPredictorUse]];

  return self;
}

@end
