// Market application. Copyright  1996-1999 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import <objectbase/Swarm.h>

@interface MarketModelSwarm: Swarm
{
  int numPredictors;
  double accuracyUpdateRate;
  double discountRate;
  double dividendJumpScale;
  
  id modelActions;
  id modelSchedule;

  id aMarket;
}

- (double)getPrice;
- (double)getDividend;
- (double)getFundamental;
- (int *)getPredictorUse;

+ createBegin: aZone;
- buildObjects;
- buildActions;
- activateIn: swarmContext;

@end
