// Market application. Copyright  1996-1999 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/*  File contains the predictors. The function Make_new (prediction) updates all 
	the predictors. It feeds them a new history, collects their predictions, and
	puts the new predictions in the global struct array "forecast." 
*/

#include "define.h"
#include "extern.h"
				
prediction predictor0 (float *, prediction);
prediction predictor1 (float *, prediction);		/* 	Local function prototypes	*/
prediction predictor2 (float *, prediction);
prediction predictor3 (float *, prediction);
prediction predictor4 (float *, prediction);
prediction predictor5 (float *, prediction);
prediction predictor6 (float *, prediction);
prediction predictor7 (float *, prediction);
prediction predictor8 (float *, prediction);
prediction predictor9 (float *, prediction);
prediction predictor10 (float *, prediction);
prediction predictor11 (float *, prediction);
prediction predictor12 (float *, prediction);
prediction predictor13 (float *, prediction);
prediction predictor14 (float *, prediction);
prediction predictor15 (float *, prediction);

/*------------------------------------------------------------------------------------*/
void Initiate_predictors (prediction forecast[])	{
			int i;
	for (i = 0; i < TOTPREDICTORS; ++i)	{
		forecast[i].numbers = 10.0;
		forecast[i].accuracy = 10.0;
		forecast[i].rank	= i;
	}
	forecast[4].accuracy =  3.0;
}
/*------------------------------------------------------------------------------------*/
void Update_accuracy (float newobs, prediction forecast[])	{
			int i; double temp;
	for (i = 0; i < TOTPREDICTORS; ++i) {
				temp = abs(newobs - forecast[i].numbers);
		forecast[i].accuracy =  (1- ETA)*forecast[i].accuracy + ETA*temp;
	}  
}
/*------------------------------------------------------------------------------------*/
void sort(prediction forecast[])	{ 	/* sort for rank based on accuracy  */
  int i, j;
  int best = 0;
  double upper;			/* rank 0 is the most accurate			*/
  
  	for (i = 0; i < TOTPREDICTORS; ++i)
  		forecast[i].flag = 0;			/* flag becomes 1 when sorted */
  
  		
  	/* Now sort out lowest member each pass and tag it with the next rank number */
  	
  	for (i = 0; i < TOTPREDICTORS; ++i)	{
  					upper = 200.0;
  	  for (j = 0; j < TOTPREDICTORS; ++j)
		if (forecast[j].accuracy <= upper && forecast[j].flag == 0)	{
							best = j;
							upper = forecast[j].accuracy;
		}
				forecast[best].rank = i;
				forecast[best].flag = 1;
	}
}
/*------------------------------------------------------------------------------------*/


void Make_new (prediction forecast[])	{	
		
	/* Runs all the prediction functions and puts the results in 
	the forecast array under forecast[i].number */
	
		
if (0 < TOTPREDICTORS)	forecast[0] = predictor0(pastdays, forecast[0]);
if (1 < TOTPREDICTORS)	forecast[1] = predictor1(pastdays, forecast[1]);
if (2 < TOTPREDICTORS)	forecast[2] = predictor2(pastdays, forecast[2]);
if (3 < TOTPREDICTORS)	forecast[3] = predictor3(pastdays, forecast[3]);
if (4 < TOTPREDICTORS)	forecast[4] = predictor4(pastdays, forecast[4]);
if (5 < TOTPREDICTORS)	forecast[5] = predictor5(pastdays, forecast[5]);
if (6 < TOTPREDICTORS)	forecast[6] = predictor6(pastdays, forecast[6]);
if (7 < TOTPREDICTORS)	forecast[7] = predictor7(pastdays, forecast[7]);
if (8 < TOTPREDICTORS)	forecast[8] = predictor8(pastdays, forecast[8]);	
if (9 < TOTPREDICTORS)	forecast[9] = predictor9(pastdays, forecast[9]);
if (10< TOTPREDICTORS)	forecast[10] = predictor10(pastdays, forecast[10]);
if (11< TOTPREDICTORS)	forecast[11] = predictor11(pastdays, forecast[11]);
if (12 < TOTPREDICTORS)	forecast[12] = predictor12(pastdays, forecast[12]);
if (13 < TOTPREDICTORS)	forecast[13] = predictor13(pastdays, forecast[13]);
if (14 < TOTPREDICTORS)	forecast[14] = predictor14(pastdays, forecast[14]);
if (15 < TOTPREDICTORS)	forecast[15] = predictor15(pastdays, forecast[15]);

}
	
/*------------------------------------------------------------------------------------*/

void print_forecasts (prediction forecast[], int *use)  {
		int i;	
	 	printf("\n	*	*	*	 Forecasts Were		*	*	*	");
	 	printf("\n      Predictor                Forecast       Accuracy       Rank            Use  ");	
	for (i = 0; i < TOTPREDICTORS; ++i)
		printf("\n% 4d %16s:     % 11.1f        %7.2f      % 5d         %5d",
				i, pred[i], forecast[i].numbers, forecast[i].accuracy, forecast[i].rank, use[i]);

}
/*------------------------------------------------------------------------------------*/

void Make_Report(int day,float hist[],float todays_number,prediction forecast[],hombre guy[],
					int use[])	{
				int i;
	
	i = HISTORY_LENGTH -1;
	fprintf(ofp,"\n\n Day % 2f      History: ",(float) day);
	for (; i >=0 ; i--)	{
		if ((HISTORY_LENGTH -i) % 25 ==24)	fprintf(ofp, "\n");	
		fprintf(ofp, " %4.1f", pastdays[i]);
	}
					
	fprintf(ofp, "\n   Predictor       Forecast     Accuracy     Rank     Use");	
	for (i = 0; i < TOTPREDICTORS; ++i)
		fprintf(ofp, "\n%-3d  %s:     % 4f        %5.2f      % 3d    % 3d",
			i, pred[i], forecast[i].numbers, forecast[i].accuracy, forecast[i].rank, use[i]);
	
	fprintf(ofp, "\nNumber attending: %f", todays_number);
	
}
/*------------------------------------------------------------------------------------*/
/*************			The Predictors are Defined Here					***************/
/*------------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------------*/
prediction predictor0 (float *hist, prediction forecast) {		
								/* trend: extrapolates the past two times  */ 
											
		forecast.numbers		=	hist[0] + (hist[0]-hist[1]);
		return forecast;
}
/*------------------------------------------------------------------------------------*/
prediction predictor1 (float *hist, prediction forecast) {		
								/* Last + 10:	 adds 10 to the number		*/
		forecast.numbers 	=    (hist[0] + 10.0);
		return forecast;
}
/*------------------------------------------------------------------------------------*/
prediction predictor2 (float *hist, prediction forecast) {		
										/* Smart trend: arbitraged trend		*/
			forecast.numbers 	=  Dividend + 0.9*( hist[0] + (hist[0]-hist[1]));
			return forecast;
}
/*------------------------------------------------------------------------------------*/
prediction predictor3 (float *hist, prediction forecast) {			
									/* 2 period trend: extrapolate on 2 periods back */ 					
														
			forecast.numbers 		=    (hist[0] +(hist[0]-hist[2])/2);
			return forecast;
}
/*------------------------------------------------------------------------------------*/
prediction predictor4 (float *hist, prediction forecast) {		
										/* Fundamental: forecast fundamental value	*/
	 		forecast.numbers 		=  Dividend *10.0;
			return forecast;
}
/*------------------------------------------------------------------------------------*/
prediction predictor5 (float *hist, prediction forecast) {		
									/* Av. prev 3: average of last three	*/
	
			forecast.numbers 	=    (hist[0] + hist[1] + hist[2]) / 3;;
			return forecast;
}
/*------------------------------------------------------------------------------------*/
prediction predictor6 (float *hist, prediction forecast) {		
										/*Same last: same as last	*/
			forecast.numbers 	=   hist[0];
			return forecast;
}
/*------------------------------------------------------------------------------------*/
prediction predictor7 (float *hist, prediction forecast) {			
															/* detects cycle of period 2 */
			forecast.numbers 		=    hist[1];
			return forecast;			
}
/*------------------------------------------------------------------------------------*/
prediction predictor8 (float *hist, prediction forecast) {			
															/* detects cycle of period 3 */
			forecast.numbers 		=    hist[2];
			return forecast;
}
/*------------------------------------------------------------------------------------*/
prediction predictor9 (float *hist, prediction forecast) {			
															/* detects cycle of period 4 */
			forecast.numbers 		=    hist[3];
			return forecast;
}
/*------------------------------------------------------------------------------------*/
prediction predictor10 (float *hist, prediction forecast) {			
															/* detects cycle of period 5 */
			forecast.numbers 		=    hist[4];
			return forecast;
}
/*------------------------------------------------------------------------------------*/
prediction predictor11 (float *hist, prediction forecast) {			
															/* detects cycle of period 6 */
			forecast.numbers 		=    hist[5];
			return forecast;
}
/*------------------------------------------------------------------------------------*/
prediction predictor12 (float *hist, prediction forecast) {			
															/* detects cycle of period 7 */
			forecast.numbers 		=    hist[6];
			return forecast;
}
/*------------------------------------------------------------------------------------*/
prediction predictor13 (float *hist, prediction forecast) {			
															/* detects cycle of period 8 */
			forecast.numbers 		=    hist[7];
			return forecast;
}
/*------------------------------------------------------------------------------------*/
prediction predictor14 (float *hist, prediction forecast) {			
															/* detects cycle of period 9 */
			forecast.numbers 		=    hist[8];
			return forecast;
}
/*------------------------------------------------------------------------------------*/
prediction predictor15 (float *hist, prediction forecast) {			
															/* detects cycle of period 10 */
			forecast.numbers 		=    hist[9];
			return forecast;
}
