
#include "JavaEnv.h"
#include "JavaClass.h"

@implementation JavaClass

+ new:  (char *)name env: (id)_env  {
  self = [JavaClass alloc];

  fprintf(stderr, "creating... java class\n");
  return [self init: name env: _env];
}

- init: (char *)name env: (id)_env  {
  [super init];
  fprintf(stderr, "JavaClass in init\n");
  /* save a copy of our environment pointer */
  env = [_env getEnv];
  /* extract and save our java class id */
  clsid = [_env findClass: name];
  fprintf(stderr, "JavaClass leaving init\n");
  return self;
}

- (JNIEnv *)getEnv {
  return env;
}

/* get the method id for a particular java method */
- (jmethodID) findMethod: (char *)method signature: (char *)sig {

  jmethodID mid = (*env)->GetMethodID(env, clsid, method, sig);
  if (mid == 0) {
    fprintf(stderr, "warning: can't find method %s\n", method);
    exit(1);
  }

  return mid;
}

/* get the method id for a particular java method */
- (jmethodID) findStaticMethod: (char *)method signature: (char *)sig {

  jmethodID mid = (*env)->GetStaticMethodID(env, clsid, method, sig);
  if (mid == 0) {
    fprintf(stderr, "warning: can't find static method %s\n", method);
    exit(1);
  }

  return mid;
}

/* call a static java method; no args, returns object */
- (jobject) callObjectStaticMethod: (jmethodID) mid {

  if (mid == 0) {
    fprintf(stderr, "callObjectStaticMethod: illegal method id\n");
    exit(1);
  }
    
  return (*env)->CallStaticObjectMethod(env, clsid, mid);
}

@end

