
#import <swarmgraph/JavaControl.h>
#import <activity/ActionCache.h>
#import <simtools/ControlPanel.h>


@implementation JavaControl;

+ new {
  self = [JavaControl alloc];
  return [self init: [JavaClass new: "JavaJCtlPanel"]];
}

- init: (id)ctlClass {
  // construct a java object and set up your object and java class ptrs
  jobject ctlObj = [ctlClass construct];
  [super init: ctlClass : ctlObj];

  // set up some local state
  _getState = 0;
  _setState = 0;
  _waitRun = 0;
  return self;
}


void sendAction(JNIEnv *env, jobject obj, 
		jlong actionCache, jobject actName,
		jlong actType, jlong arg)
{
  char * cmd = (*env)->GetStringUTFChars(env, actName, NULL);
  fprintf(stderr, "whooo whee... sendAction called with ");
  fprintf(stderr, "%s %x\n", cmd, (unsigned)actType);

  // make a new action and drop it in to be executed
  [(id)actionCache sendActionOfType: (id)actType toExecute: cmd];
  (*env)->ReleaseStringUTFChars(env, actName, cmd);
}

JNINativeMethod methods[] = {
  {"sendAction", "(JLjava/lang/String;JJ)V", (void *)sendAction}
};

- setActionCache:  (id) actionCache {
  jmethodID setActionCache;

  // first, find the java action cache class and add a native
  // method so that when it sends actions, they go back to objective
  // c, where they will get added to the action cache
  jclass jactionid = [javaEnv findClass: "JavaJAction"];
  JNIEnv * _env = [javaEnv getEnv];
  if ((*_env)->RegisterNatives(_env, jactionid, methods, 1) < 0)
    fprintf(stderr, "ERROR: couldn't register sendAction\n");


  // give the objc pointer to the java object
  setActionCache = [classid findMethod: "setActionCache" 
			    signature: "(I)V"];
  [self callVoidMethod: setActionCache : actionCache];

  // load up some actions that it can invoke
  [self addAction: "Start" : Control];
  [self addAction: "Stop" : Control];
  [self addAction: "Step" : Control];
  [self addAction: "Next" : Control];
  [self addAction: "Quit" : Control];
  [self addAction: "Probe" : Probing];

  return self;
}

- addAction:  (char *) actName : (id)actId {
  // give the objc pointer to the java object
  if (_addAction == 0)
    _addAction = [classid findMethod: "addAction" 
			  signature: "(Ljava/lang/String;I)V"];
  [self callVoidMethod: _addAction S: (char *)actName I: (int)actId];
  return self;
}

int mapToJState(id state) {
  int jstate = -1;
  if (state == ControlStateRunning)
    jstate = JControlStateRunning;
  else if (state == ControlStateStopped)
    jstate = JControlStateStopped;
  else if (state == ControlStateStepping)
    jstate = JControlStateStepping;
  else if (state == ControlStateNextTime)
    jstate = JControlStateNextTime;
  else if (state == ControlStateQuit)
    jstate = JControlStateQuit;

fprintf(stderr, "mapping from state %x->%d\n", (unsigned)state, jstate);
  return jstate;
}

id mapFromJState(int jstate) {
  id state = nil;

  switch (jstate) {
  case JControlStateRunning:
    state = ControlStateRunning;
    break;
  case JControlStateStopped:
    state = ControlStateStopped;
    break;
  case JControlStateStepping:
    state = ControlStateStepping;
    break;
  case JControlStateNextTime:
    state = ControlStateNextTime;
    break;
  case JControlStateQuit:
    state = ControlStateQuit;
    break;
  }
fprintf(stderr, "mapping from state %d->%x\n", jstate, (unsigned)state);
  return state;
}

- getState {
  if (_getState == 0) {
    _getState = [classid findMethod: "getState" signature: "()I"];
  }

  return mapFromJState([self callIntMethod: _getState]);
}

- setState: (id)state {
  if (_setState == 0)
    _setState = [classid findMethod: "setState" signature: "(I)V"];

  [self callVoidMethod: _setState : mapToJState(state)];
  return self;
}

- (void) waitRun {
  if (_waitRun == 0)
    _waitRun = [classid findMethod: "waitRUN" signature: "()V"];

  [self callVoidMethod: _waitRun];
}

@end

