'\"
'\" Copyright 1998 by Bell Labs Innovations for Lucent Technologies.
'\"
'\" Permission to use, copy, modify, and distribute this software and its
'\" documentation for any purpose and without fee is hereby granted, provided
'\" that the above copyright notice appear in all copies and that both that the
'\" copyright notice and warranty disclaimer appear in supporting documentation,
'\" and that the names of Lucent Technologies any of their entities not be used
'\" in advertising or publicity pertaining to distribution of the software
'\" without specific, written prior permission.
'\"
'\" Lucent Technologies disclaims all warranties with regard to this software,
'\" including all implied warranties of merchantability and fitness.  In no event
'\" shall Lucent Technologies be liable for any special, indirect or
'\" consequential damages or any damages whatsoever resulting from loss of use,
'\" data or profits, whether in an action of contract, negligence or other
'\" tortuous action, arising out of or in connection with the use or performance
'\" of this software.  
'\"
'\" The hierarchical listbox widget created by George Howlett.
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .HS name section [date [version]]
'\"	Replacement for .TH in other man pages.  See below for valid
'\"	section names.
'\"
'\" .AP type name in/out [indent]
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS [type [name]]
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .VS
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\"	# Heading for Tcl/Tk man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if '\\$2'BLT'        .TH \\$1 "BLT 2.4" \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
'\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
'\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
'\"	Draw four-sided box normally, but don't draw top of
'\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
'\"	Draw three-sided box if this is the box's first page,
'\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.ft CW
.nf
.sp
..
'\"	# DE - end display
.de DE
.ft R
.fi
.sp
.RE
..
.HS hierbox BLT 
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
hierbox \- Create and manipulate hierarchical listbox widgets
.BE
.SH SYNOPSIS
\fBhierbox\fR \fIpathName \fR?\fIoptions\fR?
.SH DESCRIPTION
The \fBhierbox\fR widget that displays a hierarchy of entries, drawn one
per line.  The hierarchy is a general ordered tree of entries. Each entry 
contains a list of subentries which in turn can contain their own 
lists of subentries. 
The lists of subentries can be opened (shown) or closed (hidden).
Individual entries can be selected.
.SH INTRODUCTION

.SH EXAMPLE

.SH SYNTAX
The \fBhierbox\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a hierbox widget.
.DS
\fBhierbox \fIpathName \fR?\fIoption value\fR?...
.DE
Additional options, described above, may be specified on the command
line or in the option database to configure aspects of the hierbox
such as its colors, font, text, and relief.  The \fBhierbox\fR command
returns its \fIpathName\fR argument.  At the time this command is
invoked, there must not exist a window named \fIpathName\fR, but
\fIpathName\fR's parent must exist.
.PP
An entry an icon (image), text label, and optionally a data field.  

When first created, a new hierbox has no elements.  Elements may be
added or deleted using widget operations described below.  
one or more elements may be selected as described below.  
.PP
When entries are inserted, they are given a name which can used
to specify them later.  
.PP
It is not necessary for all the elements to be
displayed in the hierbox window at once;  commands described below
may be used to change the view in the window.  Hierboxes allow
scrolling in both directions using the standard \fBxScrollCommand\fR
and \fByScrollCommand\fR options.
They also support scanning, as described below.

.SH "HIERBOX INDICES"
Many of the operations for hierbox widgets take one or more indices as
arguments.  The indices refer to individual nodes in the hierarchy.
An index may take one of several forms:
.TP 12
\fInumber\fR 
Each entry in the widget has a serial number that uniquely identifies
it.  The number doesn't indicate the location or position an entry
(for example, you can't determine the order of two entries from their
node numbers), but if an entry is moved, the node ID will still refer
to it.  Node "0" is always the root of the hierarchy.
.TP 12
\fBactive\fR
Entry where the mouse pointer is currently located.  The label 
is drawn using its active colors (see the \fB\-activebackground\fR and
\fB\-activeforeground\fR options).  The \fBactive\fR index is typically
changed by moving the mouse pointer over a entry or using the widget's
\fBactivate\fR operation. There can be only one active entry at a time.
.TP 12
\fBanchor\fR
Indicates the anchor point for the selection. The anchor point is set
by the \fBselection anchor\fR operation.
.TP 12
\fBfocus\fR
Indicates the entry that currently has focus.  
This entry is displayed with a dashed line around its label.  You can
change this using the \fBfocus\fR operation.  
.TP 12
\fBroot\fR
Indicates the root entry which is displayed as the first entry of the 
hierbox.  You can also use the node "0" to describe the root.
.TP 12
\fBend\fR
Indicates the last entry which is displayed at the bottom of 
the hierbox.  This is the last \fIopen\fR entry.
.TP 12
\fBup\fR
Entry immediately above the entry that has focus.  If the focus
is at root, then \fBup\fR is also root.
.TP 12
\fBdown\fR
Entry immediately below the entry that has focus.  If the focus
is the last entry of the hierbox, then \fBdown\fR is the same.
.TP 12
\fBprev\fR
Entry above the entry with focus.  Unlike \fIup\fR,
if the focus is at root, \fIprev\fR wraps around
to the bottom entry currently displayed in the widget.
.TP 12
\fBnext\fR
Entry below the entry with focus.  Unlike \fIdown\fR,
if the focus is on the bottom-most entry displayed in the hierbox, 
\fInext\fR wraps up to the root node.
.TP 12
\fBparent\fR
Parent of the entry with focus. The \fIparent\fR
of the root is also the root.
.TP 12
\fBsibling\fR
Next sibling of the parent. 
.TP 12
\fBview.top\fR
First partially visible entry in the hierbox window.
.TP 12
\fBview.bottom\fR
Last partially visible entry in the hierbox window.
.TP 12
\fIpath\fR 
Absolute path of an entry.  Path names refer to the node name, not
their entry labels. Paths don't have to start with a separator (see
the \fB\-separator\fR configuration option), but component names must
be separated by the designated separator.
.TP 12
\fB@\fIx\fB,\fIy\fR
Indicates the element that covers the point in the hierbox window
specified by \fIx\fR and \fIy\fR (in pixel coordinates).  If no
element covers that point, then the closest element to that
point is used.
.LP
.SH "HIERBOX OPERATIONS"
The \fBhierbox\fR operations have the invoked by specifying
the widget's pathname, the operation, and any arguments that pertain 
to that operation.  The general form is:
.sp
.CS
\fIpathName operation \fR?\fIarg arg ...\fR?
.CE
.sp
\fIOperation\fR and the \fIarg\fRs determine the exact behavior of the
command.  The following operation are available for hierbox widgets:
.TP
\fIpathName \fBactivate\fR \fIindex\fR
Sets the active entry to the one indicated by \fIindex\fR.  The active entry
is drawn with a black outline around its label and its index may be
retrieved with the index \fBactive\fR.
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBconfigure\fR
operation described below.
.TP
\fIpathName \fBclose \fR?\fB\-recurse\fR? \fIindex...\fR
Closes the level of each entry specified by \fIindex\fR.  
The Tcl script specified by the \fB\-closecommand\fR option is also invoked.
If the \fB\-recurse\fR flag is set, then each subnode is recursively
closed also.  If the entry is already closed, this command has no effect.
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR and \fIvalue\fR are described below:
.RS
.TP
\fB\-background \fIcolor\fR
Sets the background color the hierbox.  The default is \f(CWwhite\fR.
.TP
\fB\-borderwidth \fIpixels\fR
Sets the width of the 3\-D border around the outside edge of the widget.  The
\fB\-relief\fR option determines if the border is to be drawn.  The
default is \f(CW2\fR.
.TP
\fB\-closecommand \fIstring\fR
Specifies a Tcl script to be invoked when an entry is closed.  Individual
entries may override this with their own \fB\-closecommand\fR option.
The default is \f(CW""\fR.
.TP
\fB\-closerelief \fIrelief\fR
Specifies the 3-D effect for gadgets of closed entries.  \fIRelief\fR
specifies how the gadget should appear relative to entry; for example, 
\f(CWraised\fR means the gadget should appear to protrude.  The default 
is \f(CWraised\fR.
.TP
\fB\-cursor \fIcursor\fR
Specifies the widget's cursor.  The default cursor is \f(CW""\fR.
.TP
\fB\-dashes \fInumber\fR
Sets the dash style of the horizontal and vertical lines drawn connecting 
entries. \fINumber\fR is the length in pixels which represents the lengths 
of the dashes and gaps.  If \fInumber\fR is \f(CW0\fR, solid lines will 
be drawn. The default is \f(CW1\fR.
.TP
\fB\-exportselection \fIboolean\fR 
Indicates if the selection is exported.  If a hierbox is exporting its
selection then it will observe the standard X11 protocols for handling
the selection.  Selections are available as type \fBSTRING\fR;
the value of the selection will be the text of the selected elements,
with newlines separating the elements.  The default is \f(CWno\fR.
.TP
\fB\-font \fIfontName\fR 
Specifies the font for entry labels.  Individual entries may
override this with their own \fB\-font\fR option.  The default is
\f(CW*-Helvetica-Bold-R-Normal-*-12-120-*\fR.
.TP
\fB\-foreground \fIcolor\fR 
Specifies the color of entry labels.  Individual entries may
override this with their own \fB\-foreground\fR option.  The default is
\f(CWblack\fR.
.TP 
\fB\-gadgetactivebackground \fIcolor\fR
Specifies the background color non-image gadgets when the pointer 
is placed over it.  
.TP 
\fB\-gadgetactiveforeground \fIcolor\fR
Specifies the foreground color non-image gadgets when the pointer 
is placed over it.  
.TP
\fB\-gadgetbackground \fIcolor\fB
Specifies the background color of gadgets. The default is \f(CWblack\fR.
.TP 
\fB\-gadgetborderwidth \fIpixels\fR
Specifies a non-negative value indicating the width
of the 3-D border to draw around the gadgets. The default is \f(CW1\fR.
.TP
\fB\-gadgetforeground \fIcolor\fB
Specifies the foreground color of gadgets. The default is \f(CWblack\fR.
.TP
\fB\-gadgets \fIimageList\fR 
Specifies the gadget images for open and closed entries.  If \fIimageList\fR
contains the name of two Tk images, that first image will be displayed 
with the entry is closed, and the second when entry is opened.  If \fIimageList\fR
contains only one image, the same image will be drawn regardless the entry 
is opened or closed.  If \fIimageList\fR is the empty string, the default (+/-)
symbols will be drawn for gadgets. The default is \f(CW""\fR.
.TP
\fB\-height \fIpixels\fR
Specifies the requested height of widget.  The default is
\f(CW400\fR.
.TP 
\fB\-highlightbackground  \fIcolor\fR
Specifies the color to display in the traversal highlight region when
the hierbox does not have the input focus.  
.TP 
\fB\-highlightcolor \fIcolor\fR
Specifies the color to use for the traversal highlight rectangle that is
drawn around the widget when it has the input focus. 
The default is \f(CWblack\fR.
.TP 
\fB\-highlightthickness \fIpixels\fR
Specifies a non-negative value indicating the width of the highlight
rectangle to draw around the outside of the widget when it has the
input focus.
The value may have any of the forms acceptable to \fBTk_GetPixels\fR.
If the value is zero, no focus highlight is drawn around the widget.
The default is \f(CW2\fR.
.TP
\fB\-linecolor \fIcolor\fR
Sets the color of lines drawn connecting entries.  
The default is \f(CWblack\fR.
.TP
\fB\-linespacing \fIpixels\fR
Sets the number of pixels spacing between entries.  
The default is \f(CW0\fR.
.TP
\fB\-linewidth \fIpixels\fR
Set the width of the lines drawn connecting entries.  If \fIpixels\fR
is \f(CW0\fR, no lines are drawn. The default is \f(CW1\fR.
.TP
\fB\-opencommand \fIstring\fR
Specifies a Tcl script to be invoked when an entry is open.  For
example, this may be used to populate the hierarchy as it is
traversed.  Individual entries may override this with their own
\fB\-opencommand\fR option.  The default is \f(CW""\fR.
.TP
\fB\-openrelief \fIrelief\fR
Specifies the 3-D effect for gadgets of open entries.  \fIRelief\fR
specifies how the gadget should appear relative to entry; for example, 
\f(CWraised\fR means the gadget should appear to protrude.  The default 
is \f(CWsunken\fR.
.TP
\fB\-relief \fIrelief\fR
Specifies the 3-D effect for the hierbox widget.  \fIRelief\fR
specifies how the hierbox should appear relative to widget it is packed
into; for example, \f(CWraised\fR means the hierbox should
appear to protrude.  The default is \f(CWsunken\fR.
.TP
\fB\-scrolltile \fIboolean\fR 
Indicates if the tile should appear to scroll when the widget is scrolled.
.TP 
\fB\-selectbackground \fIcolor\fR
Specifies the color to use when displaying background of selected
entries. The default is \f(CWlightblue2\fR.
.TP 
\fB\-selectborderwidth \fIpixels\fR
Specifies a non-negative value indicating the width
of the raised 3-D border to draw around the labels of selected entries.
The default is \f(CW1\fR.
.TP
\fB\-selectforeground \fIcolor\fB
Specifies the color to use when drawing the labels of selected
entries. The default is \f(CWblack\fR.
.TP
\fB\-separator \fIstring\fR
Specifies the path separator of components of entries.  The separator
may several characters (such as "::").  This string is used to parse
entry pathnames.  The default is \f(CW""\fR.
.TP
\fB\-takefocus\fR \fIfocus\fR 
Provides information used when moving the focus from window to window
via keyboard traversal (e.g., Tab and Shift-Tab).  If \fIfocus\fR is
\f(CW0\fR, this means that this window should be skipped entirely during
keyboard traversal.  \f(CW1\fR means that the this window should always
receive the input focus.  An empty value means that the traversal
scripts make the decision whether to focus on the window.
The default is \f(CW"1"\fR.
.TP
\fB\-tile \fIimage\fR 
Specifies a tiled background for the widget.  If \fIimage\fR isn't
\f(CW""\fR, the background is tiled using \fIimage\fR.
Otherwise, the normal background color is drawn (see the
\fB\-background\fR option).  \fIImage\fR must be an image created
using the Tk \fBimage\fR command.  The default is \f(CW""\fR.
.TP
\fB\-trimleft \fIstring\fR
Specifies leading characters to trim from entry pathnames.
.TP
\fB\-width \fIpixels\fR
Specifies the requested width of the widget.  The default is
\f(CW200\fR.
.TP 
\fB\-xscrollcommand \fIstring\fR
Specifies the prefix for a command used to communicate with horizontal
scrollbars.  Whenever the horizontal view in the widget's window 
changes, the widget will generate a Tcl command by concatenating the 
scroll command and two numbers.  If this option is not specified, then 
no command will be executed.
.TP
\fB\-yscrollcommand \fIstring\fR
Specifies the prefix for a command used to communicate with vertical
scrollbars.   Whenever the vertical view in the widget's window 
changes, the widget will generate a Tcl command by concatenating the 
scroll command and two numbers.  If this option is not specified, then 
no command will be executed.
.RE
.TP
\fIpathName \fBcurselection\fR
Returns a list containing the numerical indices of
all of the elements in the hierbox that are currently selected.
If there are no elements selected in the hierbox then an empty
string is returned.
.TP
\fIpathName \fBdelete \fIfirst \fR?\fIlast\fR?
Deletes one or more elements of the hierbox.  \fIFirst\fR and \fIlast\fR
are indices specifying the first and last elements in the range
to delete.  If \fIlast\fR isn't specified it defaults to
\fIfirst\fR, i.e. a single element is deleted.
.TP
\fIpathName \fBentry \fIoperation\fR ?\fIargs\fR?
See the 
.SB "ENTRY OPERATIONS"
section.
.TP
\fIpathName \fBget \fR?\fB\-full\fR? \fIindex\fR...
Returns a list of the names for the indices specified.  If the \fB\-full\fR
flag is set, then the full pathnames for the elements are returned.
.TP
\fIpathName \fBindex \fR?\fB\-at\fI index\fR? \fIindex\fR 
Returns the node index of the entry specified by \fIindex\fR.  Several
forms of indices return an index
relative to currently active entry (they are describe in the section
.SB "HIERBOX INDICES"
).  The \fB\-at\fR flag lets you get
an index for some entry other than the active one.
.TP
\fIpathName \fBinsert \fR?\fB\-at \fIindex\fR? \fIposition \fIname...\fR ?\fIoption value\fR?...
Inserts zero or more new elements in an hierarchy list just before the
entry given by \fIposition\fR.  \fIPosition\fR is a number indicating where
in the list, new elements should be added.  If \fIposition\fR is \fBend\fR 
then the new elements are added to the end of the list.  Returns a list
containing the indices of the new entries.
.TP
\fIpathName \fBnearest \fIx y\fR ?\fIvarName\fR?
Returns the index of the entry closest to the given X-Y screen coordinate.
The optional argument \fIvarName\fR is the name of variable which is
set to a string over what parts of the entry the coordinate lies.  The
part names are \f(CWgadget\fR and \f(CWselect\fR.  If the coordinate is not 
directly over any entry, then \fIvarName\fR will contain the empty string.
.TP
\fIpathName \fBopen \fR?\fB\-recurse\fR? \fIindex...\fR
Displays the lists of subentries for each entry specified by \fIindex\fR.  
If an entry is not already open, the Tcl script specified by the 
\fB\-opencommand\fR option is also invoked. If the \fB\-recurse\fR flag 
is set, then each subentry is recursively opened too.  
.TP
\fIpathName \fBscan\fR \fIoption args\fR
This command is used to implement scanning on hierboxes.  It has
two forms, depending on \fIoption\fR:
.RS
.TP
\fIpathName \fBscan mark \fIx y\fR
Records \fIx\fR and \fIy\fR and the current view in the hierbox
window;  used in conjunction with later \fBscan dragto\fR commands.
Typically this command is associated with a mouse button press in
the widget.  It returns an empty string.
.TP
\fIpathName \fBscan dragto \fIx y\fR.
This command computes the difference between its \fIx\fR and \fIy\fR
arguments and the \fIx\fR and \fIy\fR arguments to the last
\fBscan mark\fR command for the widget.
It then adjusts the view by 10 times the
difference in coordinates.  This command is typically associated
with mouse motion events in the widget, to produce the effect of
dragging the list at high speed through the window.  The return
value is an empty string.
.RE
.TP
\fIpathName \fBsee \fIindex\fR
Adjust the view in the hierbox so that the entry given by \fIindex\fR
is visible in the middle of the hierbox.
.TP
\fIpathName \fBselection \fIoption arg\fR
This command is used to adjust the selection within a hierbox.  It
has several forms, depending on \fIoption\fR:
.RS
.TP
\fIpathName \fBselection anchor \fIindex\fR
Sets the selection anchor to the element given by \fIindex\fR.
.VS 8.0
If \fIindex\fR refers to a non-existent element, then the closest
element is used.
.VE
The selection anchor is the end of the selection that is fixed
while dragging out a selection with the mouse.
The index \fBanchor\fR may be used to refer to the anchor
element.
.TP
\fIpathName \fBselection clear \fIfirst \fR?\fIlast\fR?
If any of the elements between \fIfirst\fR and \fIlast\fR
(inclusive) are selected, they are deselected.
The selection state is not changed for elements outside
this range.
.TP
\fIpathName \fBselection includes \fIindex\fR
Returns 1 if the element indicated by \fIindex\fR is currently
selected, 0 if it isn't.
.TP
\fIpathName \fBselection set \fIfirst \fR?\fIlast\fR?
Selects all of the elements in the range between
\fIfirst\fR and \fIlast\fR, inclusive, without affecting
the selection state of elements outside that range.
.RE
.TP
\fIpathName \fBxview \fIargs\fR
This command is used to query and change the horizontal position of the
information in the widget's window.  It can take any of the following
forms:
.RS
.TP
\fIpathName \fBxview\fR
Returns a list containing two elements.
Each element is a real fraction between 0 and 1;  together they describe
the horizontal span that is visible in the window.
For example, if the first element is .2 and the second element is .6,
20% of the hierbox's text is off-screen to the left, the middle 40% is visible
in the window, and 40% of the text is off-screen to the right.
These are the same values passed to scrollbars via the \fB\-xscrollcommand\fR
option.
.TP
\fIpathName \fBxview\fR \fIindex\fR
Adjusts the view in the window so that the character position given by
\fIindex\fR is displayed at the left edge of the window.
Character positions are defined by the width of the character \fB0\fR.
.TP
\fIpathName \fBxview moveto\fI fraction\fR
Adjusts the view in the window so that \fIfraction\fR of the
total width of the hierbox text is off-screen to the left.
\fIfraction\fR must be a fraction between 0 and 1.
.TP
\fIpathName \fBxview scroll \fInumber what\fR
This command shifts the view in the window left or right according to
\fInumber\fR and \fIwhat\fR.
\fINumber\fR must be an integer.
\fIWhat\fR must be either \fBunits\fR or \fBpages\fR or an abbreviation
of one of these.
If \fIwhat\fR is \fBunits\fR, the view adjusts left or right by
\fInumber\fR character units (the width of the \fB0\fR character)
on the display;  if it is \fBpages\fR then the view adjusts by
\fInumber\fR screenfuls.
If \fInumber\fR is negative then characters farther to the left
become visible;  if it is positive then characters farther to the right
become visible.
.RE
.TP
\fIpathName \fByview \fI?args\fR?
This command is used to query and change the vertical position of the
text in the widget's window.
It can take any of the following forms:
.RS
.TP
\fIpathName \fByview\fR
Returns a list containing two elements, both of which are real fractions
between 0 and 1.
The first element gives the position of the hierbox element at the
top of the window, relative to the hierbox as a whole (0.5 means
it is halfway through the hierbox, for example).
The second element gives the position of the hierbox element just after
the last one in the window, relative to the hierbox as a whole.
These are the same values passed to scrollbars via the \fB\-yscrollcommand\fR
option.
.TP
\fIpathName \fByview\fR \fIindex\fR
Adjusts the view in the window so that the element given by
\fIindex\fR is displayed at the top of the window.
.TP
\fIpathName \fByview moveto\fI fraction\fR
Adjusts the view in the window so that the element given by \fIfraction\fR
appears at the top of the window.
\fIFraction\fR is a fraction between 0 and 1;  0 indicates the first
element in the hierbox, 0.33 indicates the element one-third the
way through the hierbox, and so on.
.TP
\fIpathName \fByview scroll \fInumber what\fR
This command adjusts the view in the window up or down according to
\fInumber\fR and \fIwhat\fR.
\fINumber\fR must be an integer.
\fIWhat\fR must be either \fBunits\fR or \fBpages\fR.
If \fIwhat\fR is \fBunits\fR, the view adjusts up or down by
\fInumber\fR lines;  if it is \fBpages\fR then
the view adjusts by \fInumber\fR screenfuls.
If \fInumber\fR is negative then earlier elements
become visible;  if it is positive then later elements
become visible.
.RE
.SH "ENTRY OPERATIONS"
.TP
\fIpathName \fBentry bbox\fR \fIindex\fR
Returns a list of four numbers describing the bounding box of
the text in the entry given by \fIindex\fR.
The first two elements of the list give the x and y coordinates
of the upper-left corner of the screen area covered by the entry
(specified in pixels relative to the widget) and the last two
elements give the width and height of the area, in pixels.
If no part of the entry given by \fIindex\fR is visible on the
screen then the result is an empty string.  If the element is
partially visible, the result gives the full area of the element,
including any parts that are not visible.
.TP
\fIpathName \fBentry cget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBconfigure\fR
operation described below.
.TP
\fIpathName \fBentry children\fR \fIindex\fR  ?\fIfirst\fR? ?\fIlast\fR?
Returns the list of nodes of the subentries at \fIindex\fR.  
By default, all subentries listed in \fIindex\fR are returned.  If 
a \fI\first\fR argument is present, then the node index of the 
subentry at that numeric position is returned.  If both \fIfirst\fR and
\fIlast\fR arguments are given, then the nodes of the subentries 
in that range are returned.  
.TP
\fIpathName \fBentry configure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR and \fIvalue\fR are described below:
.RS
.RE
.TP
\fIpathName \fBentry hidden \fIindex\fR
Returns 1 if the entry is currently hidden and 0 otherwise.  An
entry is not hidden if all of its ancestor entries are open.
.TP
\fIpathName \fBentry open \fIindex\fR
Returns 1 if the entry is currently open and 0 otherwise.
.TP
\fIpathName \fBentry size\fR \fB\-recurse\fR \fIindex\fR
Returns the number of subentries at \fIindex\fR.  
If the \fB\-recurse\fR flag  is set, then each the number of \fIall\fR 
subentries under \fIindex\fR is returned.  
.TP
\fIpathName \fBentry configure\fR \fB\-recurse\fR \fIindex\fR
Returns the number of subentries at \fIindex\fR.  
If the \fB\-recurse\fR flag  is set, then each the number of \fIall\fR 
subentries under \fIindex\fR is returned.  
.TP

.SH "DEFAULT BINDINGS"
.PP
Tk automatically creates class bindings for hierboxes that give them
Motif-like behavior.  Much of the behavior of a hierbox is determined
by its \fBselectMode\fR option, which selects one of four ways
of dealing with the selection.
.PP
If the selection mode is \fBsingle\fR or \fBbrowse\fR, at most one
element can be selected in the hierbox at once.
In both modes, clicking button 1 on an element selects
it and deselects any other selected item.
In \fBbrowse\fR mode it is also possible to drag the selection
with button 1.
.PP
If the selection mode is \fBmultiple\fR or \fBextended\fR,
any number of elements may be selected at once, including discontiguous
ranges.  In \fBmultiple\fR mode, clicking button 1 on an element
toggles its selection state without affecting any other elements.
In \fBextended\fR mode, pressing button 1 on an element selects
it, deselects everything else, and sets the anchor to the element
under the mouse;  dragging the mouse with button 1
down extends the selection to include all the elements between
the anchor and the element under the mouse, inclusive.
.PP
Most people will probably want to use \fBbrowse\fR mode for
single selections and \fBextended\fR mode for multiple selections;
the other modes appear to be useful only in special situations.
.PP
In addition to the above behavior, the following additional behavior
is defined by the default bindings:
.IP [1]
In \fBextended\fR mode, the selected range can be adjusted by pressing
button 1 with the Shift key down:  this modifies the selection to
consist of the elements between the anchor and the element under
the mouse, inclusive.
The un-anchored end of this new selection can also be dragged with
the button down.
.IP [2]
In \fBextended\fR mode, pressing button 1 with the Control key down
starts a toggle operation: the anchor is set to the element under
the mouse, and its selection state is reversed.  The selection state
of other elements isn't changed.
If the mouse is dragged with button 1 down, then the selection state
of all elements between the anchor and the element under the mouse
is set to match that of the anchor element;  the selection state of
all other elements remains what it was before the toggle operation
began.
.IP [3]
If the mouse leaves the hierbox window with button 1 down, the window
scrolls away from the mouse, making information visible that used
to be off-screen on the side of the mouse.
The scrolling continues until the mouse re-enters the window, the
button is released, or the end of the hierbox is reached.
.IP [4]
Mouse button 2 may be used for scanning.
If it is pressed and dragged over the hierbox, the contents of
the hierbox drag at high speed in the direction the mouse moves.
.IP [5]
If the Up or Down key is pressed, the location cursor (active
element) moves up or down one element.
If the selection mode is \fBbrowse\fR or \fBextended\fR then the
new active element is also selected and all other elements are
deselected.
In \fBextended\fR mode the new active element becomes the
selection anchor.
.IP [6]
In \fBextended\fR mode, Shift-Up and Shift-Down move the location
cursor (active element) up or down one element and also extend
the selection to that element in a fashion similar to dragging
with mouse button 1.
.IP [7]
The Left and Right keys scroll the hierbox view left and right
by the width of the character \fB0\fR.
Control-Left and Control-Right scroll the hierbox view left and
right by the width of the window.
Control-Prior and Control-Next also scroll left and right by
the width of the window.
.IP [8]
The Prior and Next keys scroll the hierbox view up and down
by one page (the height of the window).
.IP [9]
The Home and End keys scroll the hierbox horizontally to
the left and right edges, respectively.
.IP [10]
Control-Home sets the location cursor to the the first element in
the hierbox, selects that element, and deselects everything else
in the hierbox.
.IP [11]
Control-End sets the location cursor to the the last element in
the hierbox, selects that element, and deselects everything else
in the hierbox.
.IP [12]
In \fBextended\fR mode, Control-Shift-Home extends the selection
to the first element in the hierbox and Control-Shift-End extends
the selection to the last element.
.IP [13]
In \fBmultiple\fR mode, Control-Shift-Home moves the location cursor
to the first element in the hierbox and Control-Shift-End moves
the location cursor to the last element.
.IP [14]
The space and Select keys make a selection at the location cursor
(active element) just as if mouse button 1 had been pressed over
this element.
.IP [15]
In \fBextended\fR mode, Control-Shift-space and Shift-Select
extend the selection to the active element just as if button 1
had been pressed with the Shift key down.
.IP [16]
In \fBextended\fR mode, the Escape key cancels the most recent
selection and restores all the elements in the selected range
to their previous selection state.
.IP [17]
Control-slash selects everything in the widget, except in
\fBsingle\fR and \fBbrowse\fR modes, in which case it selects
the active element and deselects everything else.
.IP [18]
Control-backslash deselects everything in the widget, except in
\fBbrowse\fR mode where it has no effect.
.IP [19]
The F16 key (labelled Copy on many Sun workstations) or Meta-w
copies the selection in the widget to the clipboard, if there is
a selection.

.PP
The behavior of hierboxes can be changed by defining new bindings for
individual widgets or by redefining the class bindings.

.SH KEYWORDS
hierbox, widget

If a hierbox
is exporting its selection (see \fBexportSelection\fR option), then it
will observe the standard X11 protocols for handling the selection.
Hierbox selections are available as type \fBSTRING\fR; the value of
the selection will be the text of the selected elements, with newlines
separating the elements.
