/****************************************************************************
 * NCSA HDF								    *
 * Software Development Group						    *
 * National Center for Supercomputing Applications			    *
 * University of Illinois at Urbana-Champaign				    *
 * 605 E. Springfield, Champaign IL 61820				    *
 *									    *
 * For conditions of distribution and use, see the accompanying		    *
 * hdf/COPYING file.							    *
 *									    *
 ****************************************************************************/

/*
 * This file contains public declarations for the H5D module.
 */
#ifndef _H5Dpublic_H
#define _H5Dpublic_H

/* Public headers needed by this file */
#include <H5public.h>
#include <H5Ipublic.h>

/* Values for the H5D_LAYOUT property */
typedef enum H5D_layout_t {
    H5D_LAYOUT_ERROR	= -1,

    H5D_COMPACT		= 0,	/*raw data is very small		     */
    H5D_CONTIGUOUS	= 1,	/*the default				     */
    H5D_CHUNKED		= 2,	/*slow and fancy			     */

    H5D_NLAYOUTS	= 3	/*this one must be last!		     */
} H5D_layout_t;

/* Values for the data transfer property */
typedef enum H5D_transfer_t {
    H5D_XFER_INDEPENDENT,	/*Independent data transfer		     */
    H5D_XFER_COLLECTIVE,	/*Collective data transfer		     */
    H5D_XFER_DFLT		/*default data transfer mode		     */
} H5D_transfer_t;


#ifdef __cplusplus
extern "C" {
#endif

hid_t H5Dcreate (hid_t file_id, const char *name, hid_t type_id,
		 hid_t space_id, hid_t plist_id);
hid_t H5Dopen (hid_t file_id, const char *name);
herr_t H5Dclose (hid_t dset_id);
hid_t H5Dget_space (hid_t dset_id);
hid_t H5Dget_type (hid_t dset_id);
hid_t H5Dget_create_plist (hid_t dset_id);
herr_t H5Dread (hid_t dset_id, hid_t mem_type_id, hid_t mem_space_id,
		hid_t file_space_id, hid_t plist_id, void *buf/*out*/);
herr_t H5Dwrite (hid_t dset_id, hid_t mem_type_id, hid_t mem_space_id,
		 hid_t file_space_id, hid_t plist_id, const void *buf);
herr_t H5Dextend (hid_t dset_id, const hsize_t *size);

#ifdef __cplusplus
}
#endif
#endif
