// Common.xgens.floats.m

// 
// Common code for split generators
// Random version 0.7
//

// ----- Producing generator output: -----

-(float) getFloatSample: (unsigned) vGen {
   // One 32-bit unsigned random number is used
   // to fill the 24-bit mantissa of a float

   return (float) [self getThinDoubleSample: vGen];
}

-(double) getThinDoubleSample: (unsigned) vGen {
  // *One single* 32-bit unsigned random number is used
  // to fill the 53-bit mantissa of a double

   return (double) [self getUnsignedSample: vGen] * invModMult;
}

-(double) getDoubleSample: (unsigned) vGen {
   // *Two* 32-bit unsigned random numbers are used
   // to fill the 53-bit mantissa of a double.
   // Since everyone uses standard 8-byte doubles with 53-bit mantissa,
   // truncating a long double to a double should be portable.

   return (double) [self getLongDoubleSample: vGen];
}

-(long double) getLongDoubleSample: (unsigned) vGen {
   long double ld;
   // Two 32-bit unsigned random numbers are used
   // to fill the mantissa of a long double.
   // NOTE: since the size of a long double is machine dependent,
   // using this method may render the simulation non-portable!

   ld = (long double) [self getUnsignedSample: vGen] * invModMult
      + (long double) [self getUnsignedSample: vGen] * invModMult2;

   return ld;
}


