// Swarm library. Copyright (C) 1996-1998 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import <objectbase.h>
#import <objectbase/Probe.h>
#import <objectbase/VarProbe.h>
#import <objectbase/ProbeMap.h>
#import <tkobjc.h>
#import <collections.h>

@interface TestObject : SwarmObject {
  int firstInt;
  long long longLong;
  char firstChar;
  char secondChar;
  int secondInt;
  float aFloat;
}
@end

@implementation TestObject
@end

int
main(int argc, char ** argv) {
  TestObject * o;
  VarProbe *probe;
  VarProbe *probe2;
  ProbeMap * probeMap; 
  char buffer[16384];
  char buffer2[16384];

  initSwarm(argc, argv);

  o = [TestObject create: globalZone];

  printf("%s\n",[o name]) ;
	
  probe = [VarProbe createBegin: globalZone];
  [probe setProbedClass: [o class]];
  [probe setProbedVariable: "secondChar"];
  probe = [probe createEnd];

  probe2 = [VarProbe createBegin: globalZone];
  [probe2 setProbedClass: [o class]];
  [probe2 setProbedVariable: "aFloat"];   
  probe2 = [probe2 createEnd];
  [probe2 setFloatFormat: "%.3f"];
  
  probeMap = [EmptyProbeMap createBegin: globalZone];
  [probeMap setProbedClass: [o class]];
  probeMap = [probeMap createEnd];

  o->firstInt = (1<<17) + 1;
  o->firstChar = 64;
  o->secondChar = 32;
  o->secondInt = - o->firstInt;
  o->longLong = 1<<31;
  o->longLong *= 64;
  o->aFloat = 0.675264652452;

  printf("first probe\n");
  printf("%s\n", [probe probeAsString: o Buffer: buffer]);
  [probe setStringReturnType: CharString] ;
  printf("%s\n", [probe probeAsString: o Buffer: buffer]);
  [probe setStringReturnType: IntString] ;
  printf("%s\n", [probe probeAsString: o Buffer: buffer]);

  printf("second probe\n");
  printf("%s\n", [probe2 probeAsString: o Buffer: buffer2]);

  [probeMap addProbe: 
        [[probeLibrary getProbeForVariable: "aFloat"
				    inClass: [o class]]
        setFloatFormat: "%.3f"]];
  
  [probeMap addProbe: 
               [probe2 setFloatFormat: "%.3f"]];

  [probeLibrary setProbeMap: probeMap For: [o class]];

  printf("%s\n", [[probeLibrary getProbeForVariable: "aFloat"inClass: [o class]]
                   probeAsString: o Buffer: buffer]);
  
  exit(0) ;
}
