/*
 * Decompiled with CFR 0.152.
 */
package at.dms.backend;

import at.dms.backend.BasicBlock;
import at.dms.backend.QLiteral;
import at.dms.backend.QNode;
import at.dms.backend.QOrigin;
import at.dms.backend.QQuadruple;
import at.dms.backend.QStack;
import at.dms.backend.QTemporary;
import at.dms.backend.TreeWalker;
import java.util.Hashtable;
import java.util.Stack;

public class StackSchleduler
extends TreeWalker {
    private Stack stack = new Stack();
    private Hashtable defs = new Hashtable();

    public void run() {
        this.traverse();
    }

    protected void processNode(QNode qNode) {
        QOrigin[] qOriginArray = qNode.getOrigins();
        int n = 0;
        int n2 = qOriginArray.length - 1;
        while (n2 >= 0) {
            if (qOriginArray[n2] == this.getTemp(n) && !StackSchleduler.isInList(this.getTemp(n), qNode.getLiveout())) {
                this.getNode(n).useStack();
                qNode.setOrigin(new QStack(this.getTemp(n).getType()), n2);
                ++n;
            } else if (!(qOriginArray[n2] instanceof QLiteral)) break;
            --n2;
        }
        if (qNode.hasSideEffect()) {
            this.stack.setSize(0);
        }
        if (qNode.isStore()) {
            this.stack.push(qNode);
        }
    }

    protected void kill() {
        this.stack.setSize(0);
    }

    private QTemporary getTemp(int n) {
        QQuadruple qQuadruple = this.getNode(n);
        return qQuadruple == null ? null : qQuadruple.getDef();
    }

    private QQuadruple getNode(int n) {
        return this.stack.size() - 1 - n >= 0 ? (QQuadruple)this.stack.elementAt(this.stack.size() - 1 - n) : null;
    }

    private static boolean isInList(QTemporary qTemporary, QTemporary[] qTemporaryArray) {
        int n = 0;
        while (n < qTemporaryArray.length) {
            if (qTemporary == qTemporaryArray[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public StackSchleduler(BasicBlock[] basicBlockArray, BasicBlock[] basicBlockArray2) {
        super(basicBlockArray, basicBlockArray2);
    }
}

