/*
 * Decompiled with CFR 0.152.
 */
package at.dms.compiler.tools.jperf;

import java.io.PrintWriter;

public class Keywords {
    private final String[] keywords;
    private final int minWordLength;
    private final int maxWordLength;
    private final char minCharValue;
    private final char maxCharValue;

    public final int size() {
        return this.keywords.length;
    }

    public final String elementAt(int n) {
        return this.keywords[n];
    }

    public final int getMaxWordLength() {
        return this.maxWordLength;
    }

    public final char getMinCharValue() {
        return this.minCharValue;
    }

    public final char getMaxCharValue() {
        return this.maxCharValue;
    }

    public void genCode(PrintWriter printWriter) {
        if (this.minCharValue == '\'') {
            printWriter.println("  private static final int MIN_CHAR_VAL = '\\'';");
        } else {
            printWriter.println("  private static final int MIN_CHAR_VAL = '" + this.minCharValue + "';");
        }
        if (this.maxCharValue == '\'') {
            printWriter.println("  private static final int MAX_CHAR_VAL = '\\'';");
        } else {
            printWriter.println("  private static final int MAX_CHAR_VAL = '" + this.maxCharValue + "';");
        }
        printWriter.println("  private static final int MIN_WORD_LENG = " + this.minWordLength + ";");
        printWriter.println("  private static final int MAX_WORD_LENG = " + this.maxWordLength + ";");
        printWriter.println("  private static final int TOTAL_KEYWORDS = " + this.keywords.length + ";");
        printWriter.println("  private static final char[][] keywords = new char[][] {");
        int n = 0;
        while (n < this.keywords.length) {
            if (n != 0) {
                printWriter.println(",");
            }
            printWriter.print("    \"" + this.keywords[n] + "\".toCharArray()");
            ++n;
        }
        printWriter.println();
        printWriter.println("  };");
    }

    public Keywords(String[] stringArray) {
        this.keywords = stringArray;
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        char c = '~';
        char c2 = ' ';
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (stringArray[n3].length() > n2) {
                n2 = stringArray[n3].length();
            }
            if (stringArray[n3].length() < n) {
                n = stringArray[n3].length();
            }
            int n4 = 0;
            while (n4 < stringArray[n3].length()) {
                char c3 = stringArray[n3].charAt(n4);
                if (c3 < c) {
                    c = c3;
                }
                if (c3 > c2) {
                    c2 = c3;
                }
                ++n4;
            }
            ++n3;
        }
        this.minWordLength = n;
        this.maxWordLength = n2;
        this.minCharValue = c;
        this.maxCharValue = c2;
    }
}

