/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.ConstantPool;
import at.dms.classfile.DoubleConstant;
import at.dms.classfile.FloatConstant;
import at.dms.classfile.Instruction;
import at.dms.classfile.IntegerConstant;
import at.dms.classfile.LongConstant;
import at.dms.classfile.PooledConstant;
import at.dms.classfile.StringConstant;
import at.dms.util.InconsistencyException;
import java.io.DataOutput;
import java.io.IOException;

public class PushLiteralInstruction
extends Instruction {
    private Operand operand;
    private Object value;

    public boolean canComplete() {
        return true;
    }

    public boolean isLiteral() {
        return true;
    }

    int getSize() {
        return 1 + (this.operand == null ? 0 : this.operand.getSize());
    }

    public Object getLiteral() {
        return this.value;
    }

    public int getPushedOnStack() {
        return this.getStack();
    }

    public byte getReturnType() {
        switch (this.getOpcode()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return 4;
            }
            case 11: 
            case 12: 
            case 13: {
                return 3;
            }
            case 9: 
            case 10: 
            case 20: {
                return 5;
            }
            case 14: 
            case 15: {
                return 2;
            }
        }
        throw new InconsistencyException("invalid opcode: " + this.getOpcode());
    }

    public int getStack() {
        switch (this.getOpcode()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return 1;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 20: {
                return 2;
            }
        }
        throw new InconsistencyException("invalid opcode: " + this.getOpcode());
    }

    void resolveConstants(ConstantPool constantPool) {
        if (this.operand != null) {
            this.operand.resolveConstants(constantPool);
        }
    }

    void write(ConstantPool constantPool, DataOutput dataOutput) throws IOException {
        dataOutput.writeByte((byte)this.getOpcode());
        if (this.operand != null) {
            this.operand.write(constantPool, dataOutput);
        }
    }

    public PushLiteralInstruction(double d) {
        super(20);
        if (d == 0.0 && Double.doubleToLongBits(d) == Double.doubleToLongBits(0.0)) {
            this.setOpcode(14);
        } else if (d == 1.0) {
            this.setOpcode(15);
        } else {
            PushLiteralInstruction pushLiteralInstruction = this;
            if (pushLiteralInstruction == null) {
                throw null;
            }
            this.operand = pushLiteralInstruction.new ConstantOperand(new DoubleConstant(d), true);
        }
        this.value = new Double(d);
    }

    public PushLiteralInstruction(float f) {
        super(18);
        if (f == 0.0f && Float.floatToIntBits(f) == Float.floatToIntBits(0.0f)) {
            this.setOpcode(11);
        } else if (f == 1.0f) {
            this.setOpcode(12);
        } else if (f == 2.0f) {
            this.setOpcode(13);
        } else {
            PushLiteralInstruction pushLiteralInstruction = this;
            if (pushLiteralInstruction == null) {
                throw null;
            }
            this.operand = pushLiteralInstruction.new ConstantOperand(new FloatConstant(f), false);
        }
        this.value = new Float(f);
    }

    public PushLiteralInstruction(int n) {
        super(18);
        if (n >= -1 && n <= 5) {
            switch (n) {
                case -1: {
                    this.setOpcode(2);
                    break;
                }
                case 0: {
                    this.setOpcode(3);
                    break;
                }
                case 1: {
                    this.setOpcode(4);
                    break;
                }
                case 2: {
                    this.setOpcode(5);
                    break;
                }
                case 3: {
                    this.setOpcode(6);
                    break;
                }
                case 4: {
                    this.setOpcode(7);
                    break;
                }
                case 5: {
                    this.setOpcode(8);
                    break;
                }
            }
        } else if (n >= -128 && n <= 127) {
            this.setOpcode(16);
            PushLiteralInstruction pushLiteralInstruction = this;
            if (pushLiteralInstruction == null) {
                throw null;
            }
            this.operand = pushLiteralInstruction.new ByteOperand((byte)n);
        } else if (n >= Short.MIN_VALUE && n <= Short.MAX_VALUE) {
            this.setOpcode(17);
            PushLiteralInstruction pushLiteralInstruction = this;
            if (pushLiteralInstruction == null) {
                throw null;
            }
            this.operand = pushLiteralInstruction.new ShortOperand((short)n);
        } else {
            PushLiteralInstruction pushLiteralInstruction = this;
            if (pushLiteralInstruction == null) {
                throw null;
            }
            this.operand = pushLiteralInstruction.new ConstantOperand(new IntegerConstant(n), false);
        }
        this.value = new Integer(n);
    }

    public PushLiteralInstruction(long l) {
        super(20);
        if (l == 0L) {
            this.setOpcode(9);
        } else if (l == 1L) {
            this.setOpcode(10);
        } else {
            PushLiteralInstruction pushLiteralInstruction = this;
            if (pushLiteralInstruction == null) {
                throw null;
            }
            this.operand = pushLiteralInstruction.new ConstantOperand(new LongConstant(l), true);
        }
        this.value = new Long(l);
    }

    public PushLiteralInstruction(String string) {
        super(18);
        PushLiteralInstruction pushLiteralInstruction = this;
        if (pushLiteralInstruction == null) {
            throw null;
        }
        this.operand = pushLiteralInstruction.new ConstantOperand(new StringConstant(string), false);
        this.value = string;
    }

    public PushLiteralInstruction(PooledConstant pooledConstant, boolean bl) {
        super(18);
        PushLiteralInstruction pushLiteralInstruction = this;
        if (pushLiteralInstruction == null) {
            throw null;
        }
        this.operand = pushLiteralInstruction.new ConstantOperand(pooledConstant, bl);
        this.value = pooledConstant.getLiteral();
        if (this.value instanceof Long || this.value instanceof Double) {
            this.setOpcode(20);
        }
    }

    static interface Operand {
        public void resolveConstants(ConstantPool var1);

        public int getSize();

        public void write(ConstantPool var1, DataOutput var2) throws IOException;
    }

    private class ByteOperand
    implements Operand {
        private final byte value;

        public void resolveConstants(ConstantPool constantPool) {
        }

        public int getSize() {
            return 1;
        }

        public void write(ConstantPool constantPool, DataOutput dataOutput) throws IOException {
            dataOutput.writeByte(this.value);
        }

        ByteOperand(byte by) {
            this.value = by;
        }
    }

    private class ShortOperand
    implements Operand {
        private final short value;

        public void resolveConstants(ConstantPool constantPool) {
        }

        public int getSize() {
            return 2;
        }

        public void write(ConstantPool constantPool, DataOutput dataOutput) throws IOException {
            dataOutput.writeShort(this.value);
        }

        ShortOperand(short s) {
            this.value = s;
        }
    }

    private class ConstantOperand
    implements Operand {
        private final PooledConstant value;
        private boolean wide;

        public void resolveConstants(ConstantPool constantPool) {
            constantPool.addItem(this.value);
        }

        public int getSize() {
            boolean bl = this.wide = this.value.getIndex() > 255;
            if (PushLiteralInstruction.this.getOpcode() != 20) {
                if (this.wide) {
                    PushLiteralInstruction.this.setOpcode(19);
                } else {
                    PushLiteralInstruction.this.setOpcode(18);
                }
            }
            return PushLiteralInstruction.this.getOpcode() == 20 || this.wide ? 2 : 1;
        }

        public void write(ConstantPool constantPool, DataOutput dataOutput) throws IOException {
            short s = this.value.getIndex();
            if (this.wide || PushLiteralInstruction.this.getOpcode() == 20) {
                dataOutput.writeShort(s);
            } else {
                dataOutput.writeByte((byte)(s & 0xFF));
            }
        }

        ConstantOperand(PooledConstant pooledConstant, boolean bl) {
            this.value = pooledConstant;
            this.wide = bl;
        }
    }
}

