/*
 * Decompiled with CFR 0.152.
 */
package at.dms.dis;

import at.dms.classfile.BadAccessorException;
import at.dms.classfile.ClassInfo;
import at.dms.classfile.ClassPath;
import at.dms.classfile.CodeInfo;
import at.dms.classfile.FieldInfo;
import at.dms.classfile.HandlerInfo;
import at.dms.classfile.Instruction;
import at.dms.classfile.LocalVariableInfo;
import at.dms.classfile.Member;
import at.dms.classfile.MethodInfo;
import at.dms.compiler.CompilerMessages;
import at.dms.compiler.UnpositionedError;
import at.dms.dis.Constants;
import at.dms.dis.DisMessages;
import at.dms.dis.DisOptions;
import at.dms.dis.HandleCreator;
import at.dms.dis.IndentingWriter;
import at.dms.dis.InstructionHandle;
import at.dms.util.InconsistencyException;
import at.dms.util.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class Disassembler
implements at.dms.classfile.Constants,
Constants {
    private final ClassInfo classInfo;
    private final boolean optionSortMembers;
    private final boolean optionShowStack;

    public static void disassemble(String string, String string2, DisOptions disOptions) throws UnpositionedError {
        ClassInfo classInfo;
        if (string.endsWith(".class")) {
            try {
                classInfo = new ClassInfo(new DataInputStream(new BufferedInputStream(new FileInputStream(string), 2048)), false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new UnpositionedError(CompilerMessages.FILE_NOT_FOUND, new Object[]{string});
            }
        } else {
            classInfo = ClassPath.getClassInfo(string.replace('.', '/'), false);
        }
        if (classInfo == null) {
            throw new UnpositionedError(DisMessages.CLASS_NOT_FOUND, new Object[]{string});
        }
        Disassembler.writeAssemblerFile(classInfo, string2, disOptions);
    }

    private static void writeAssemblerFile(ClassInfo classInfo, String string, DisOptions disOptions) throws UnpositionedError {
        Object object;
        String[] stringArray = Utils.splitQualifiedName(classInfo.getName());
        if (stringArray[0] != null) {
            object = stringArray[0].replace('.', File.separatorChar).replace('/', File.separatorChar);
            if (string != null) {
                string = string + File.separator + (String)object;
            }
        }
        if (!disOptions.stdout && disOptions.destination != null) {
            object = new File(disOptions.destination);
            if (!((File)object).exists()) {
                ((File)object).mkdirs();
            }
            if (!((File)object).isDirectory()) {
                throw new UnpositionedError(CompilerMessages.IO_EXCEPTION, new Object[]{disOptions.destination});
            }
        }
        object = null;
        try {
            PrintWriter printWriter;
            if (disOptions.stdout) {
                object = null;
                printWriter = new PrintWriter(System.out);
            } else {
                object = new File(string, stringArray[1] + ".ksm");
                printWriter = new PrintWriter(new BufferedWriter(new FileWriter((File)object)));
            }
            Disassembler disassembler = new Disassembler(classInfo, disOptions.stack, disOptions.sorted);
            disassembler.writeClass(new IndentingWriter(printWriter));
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException iOException) {
            throw new UnpositionedError(CompilerMessages.IO_EXCEPTION, new Object[]{((File)object).getPath(), iOException.getMessage()});
        }
    }

    private void writeClass(IndentingWriter indentingWriter) {
        String[] stringArray;
        indentingWriter.println("// compiler version: " + this.classInfo.getMajorVersion() + "." + this.classInfo.getMinorVersion());
        indentingWriter.println();
        if (this.classInfo.getSourceFile() != null) {
            indentingWriter.println("@source \"" + this.classInfo.getSourceFile() + "\"");
        }
        this.writeModifiers(indentingWriter, this.classInfo.getModifiers() & 0xFFFFFFDF);
        if ((this.classInfo.getModifiers() & 0x200) > 0) {
            indentingWriter.print("interface ");
        } else {
            indentingWriter.print("class ");
        }
        indentingWriter.print(Disassembler.convertQualifiedName(this.classInfo.getName()));
        if (this.classInfo.getSuperClass() != null) {
            indentingWriter.print(" extends ");
            indentingWriter.print(Disassembler.convertQualifiedName(this.classInfo.getSuperClass()));
        }
        if ((stringArray = this.classInfo.getInterfaces()) != null && stringArray.length > 0) {
            indentingWriter.print(" implements");
            int n = 0;
            while (n < stringArray.length) {
                indentingWriter.print((n == 0 ? " " : ", ") + Disassembler.convertQualifiedName(stringArray[n]));
                ++n;
            }
        }
        indentingWriter.print(" {");
        Member[] memberArray = this.classInfo.getFields();
        if (this.optionSortMembers) {
            Disassembler.sort(memberArray);
        }
        int n = 0;
        while (n < memberArray.length) {
            this.writeField(indentingWriter, (FieldInfo)memberArray[n]);
            ++n;
        }
        indentingWriter.println();
        Member[] memberArray2 = this.classInfo.getMethods();
        if (this.optionSortMembers) {
            Disassembler.sort(memberArray2);
        }
        int n2 = 0;
        while (n2 < memberArray2.length) {
            this.writeMethod(indentingWriter, (MethodInfo)memberArray2[n2]);
            if (n2 != memberArray2.length - 1) {
                indentingWriter.println();
            }
            ++n2;
        }
        indentingWriter.println();
        indentingWriter.println("}");
    }

    private void writeField(IndentingWriter indentingWriter, FieldInfo fieldInfo) {
        indentingWriter.incrementLevel();
        indentingWriter.println();
        this.writeModifiers(indentingWriter, fieldInfo.getModifiers());
        indentingWriter.print(Disassembler.convertFieldSignature(fieldInfo.getSignature()) + " ");
        indentingWriter.print(fieldInfo.getName());
        Object object = fieldInfo.getConstantValue();
        if (object != null) {
            indentingWriter.print(" = " + Disassembler.convertLiteral(object));
        }
        indentingWriter.print(";");
        indentingWriter.decrementLevel();
    }

    private void writeMethod(IndentingWriter indentingWriter, MethodInfo methodInfo) {
        indentingWriter.incrementLevel();
        indentingWriter.println();
        indentingWriter.println("/**");
        indentingWriter.println(" * " + methodInfo.getName());
        indentingWriter.println(" *");
        if (methodInfo.getCodeInfo() != null) {
            indentingWriter.println(" * @stack\t" + methodInfo.getCodeInfo().getMaxStack());
            indentingWriter.println(" * @locals\t" + methodInfo.getCodeInfo().getMaxLocals());
        }
        indentingWriter.println(" */");
        this.writeModifiers(indentingWriter, methodInfo.getModifiers());
        String[] stringArray = Disassembler.convertMethodSignature(methodInfo.getSignature());
        indentingWriter.print(stringArray[1]);
        indentingWriter.print(" ");
        indentingWriter.print(methodInfo.getName());
        indentingWriter.print(stringArray[0]);
        String[] stringArray2 = methodInfo.getExceptions();
        if (stringArray2 != null) {
            indentingWriter.print(" throws");
            int n = 0;
            while (n < stringArray2.length) {
                indentingWriter.print((n == 0 ? " " : ", ") + stringArray2[n].replace('/', '.'));
                ++n;
            }
        }
        if (methodInfo.getCodeInfo() == null) {
            indentingWriter.print(";");
        } else {
            indentingWriter.print(" {");
            this.writeCodeInfo(indentingWriter, methodInfo.getCodeInfo());
            indentingWriter.println();
            indentingWriter.print("}");
        }
        indentingWriter.decrementLevel();
    }

    private void writeCodeInfo(IndentingWriter indentingWriter, CodeInfo codeInfo) {
        Instruction[] instructionArray = codeInfo.getInstructions();
        InstructionHandle[] instructionHandleArray = new InstructionHandle[instructionArray.length];
        int n = 0;
        while (n < instructionHandleArray.length) {
            instructionHandleArray[n] = new InstructionHandle(instructionArray[n], n);
            ++n;
        }
        try {
            codeInfo.transformAccessors(new HandleCreator(instructionArray, instructionHandleArray));
        }
        catch (BadAccessorException badAccessorException) {
            throw new InconsistencyException(badAccessorException.getMessage());
        }
        indentingWriter.incrementLevel();
        n = 0;
        while (n < instructionHandleArray.length) {
            instructionHandleArray[n].write(indentingWriter, this.optionShowStack);
            ++n;
        }
        this.writeHandlerInfo(indentingWriter, codeInfo);
        this.writeLocalVariableInfo(indentingWriter, codeInfo);
        indentingWriter.decrementLevel();
    }

    private void writeModifiers(IndentingWriter indentingWriter, int n) {
        if ((n & 1) != 0) {
            indentingWriter.print("public ");
        } else if ((n & 4) != 0) {
            indentingWriter.print("protected ");
        } else if ((n & 2) != 0) {
            indentingWriter.print("private ");
        }
        if ((n & 8) != 0) {
            indentingWriter.print("static ");
        }
        if ((n & 0x400) != 0) {
            indentingWriter.print("abstract ");
        }
        if ((n & 0x10) != 0) {
            indentingWriter.print("final ");
        }
        if ((n & 0x100) != 0) {
            indentingWriter.print("native ");
        }
        if ((n & 0x20) != 0) {
            indentingWriter.print("synchronized ");
        }
        if ((n & 0x80) != 0) {
            indentingWriter.print("transient ");
        }
        if ((n & 0x40) != 0) {
            indentingWriter.print("volatile ");
        }
        if ((n & 0x800) != 0) {
            indentingWriter.print("strictfp ");
        }
    }

    private void writeHandlerInfo(IndentingWriter indentingWriter, CodeInfo codeInfo) {
        HandlerInfo[] handlerInfoArray = codeInfo.getHandlers();
        int n = 0;
        while (n < handlerInfoArray.length) {
            indentingWriter.println();
            indentingWriter.print("@catch\t" + ((InstructionHandle)handlerInfoArray[n].getHandler()).getLabel());
            if (handlerInfoArray[n].getThrown() != null) {
                indentingWriter.print(" " + handlerInfoArray[n].getThrown().replace('/', '.'));
            }
            indentingWriter.print(" [" + ((InstructionHandle)handlerInfoArray[n].getStart()).getLabel() + ", " + ((InstructionHandle)handlerInfoArray[n].getEnd()).getLabel() + "]");
            ++n;
        }
    }

    private void writeLocalVariableInfo(IndentingWriter indentingWriter, CodeInfo codeInfo) {
        LocalVariableInfo[] localVariableInfoArray = codeInfo.getLocalVariables();
        if (localVariableInfoArray == null) {
            return;
        }
        int n = 0;
        while (n < localVariableInfoArray.length) {
            if (n == 0) {
                indentingWriter.println();
            }
            indentingWriter.println("@var\t" + localVariableInfoArray[n].getSlot() + ": " + localVariableInfoArray[n].getName() + " " + Disassembler.convertFieldSignature(localVariableInfoArray[n].getType()) + " [ " + ((InstructionHandle)localVariableInfoArray[n].getStart()).getLabel() + ", " + ((InstructionHandle)localVariableInfoArray[n].getEnd()).getLabel() + "]");
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static String convertFieldSignature(String string) {
        int n = 0;
        while (string.charAt(n) == '[') {
            ++n;
        }
        if ((string = string.substring(n)).charAt(0) == 'Z') {
            string = "boolean";
        } else if (string.charAt(0) == 'B') {
            string = "byte";
        } else if (string.charAt(0) == 'C') {
            string = "char";
        } else if (string.charAt(0) == 'D') {
            string = "double";
        } else if (string.charAt(0) == 'F') {
            string = "float";
        } else if (string.charAt(0) == 'I') {
            string = "int";
        } else if (string.charAt(0) == 'J') {
            string = "long";
        } else if (string.charAt(0) == 'S') {
            string = "short";
        } else if (string.charAt(0) == 'V') {
            string = "void";
        } else {
            if (string.charAt(0) != 'L') {
                throw new InconsistencyException("UNEXPECTED TYPE " + string.charAt(0));
            }
            string = string.substring(1, string.length() - 1);
        }
        while (n > 0) {
            string = string + "[]";
            --n;
        }
        return string.replace('/', '.');
    }

    /*
     * Unable to fully structure code
     */
    static String[] convertMethodSignature(String var0) {
        if (var0.charAt(0) != '(') {
            throw new InconsistencyException("UNEXPECTED TYPE " + var0);
        }
        var1_1 = "(";
        var0 = var0.substring(1);
        while (var0.charAt(0) != ')') {
            block4: {
                var2_2 = 0;
                while (var0.charAt(var2_2) == '[') {
                    ++var2_2;
                }
                if (var0.charAt(var2_2) == 'L') ** GOTO lbl14
                ++var2_2;
                break block4;
lbl-1000:
                // 1 sources

                {
                    ++var2_2;
lbl14:
                    // 2 sources

                    ** while (var0.charAt((int)var2_2) != ';')
                }
lbl15:
                // 1 sources

                ++var2_2;
            }
            var1_1 = var1_1 + Disassembler.convertFieldSignature(var0.substring(0, var2_2)) + (var0.charAt(var2_2) != ')' ? ", " : "");
            var0 = var0.substring(var2_2);
        }
        var1_1 = var1_1 + ")";
        return new String[]{var1_1, Disassembler.convertFieldSignature(var0.substring(1))};
    }

    static String convertQualifiedName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.replace('/', '.'), ".");
        String string2 = stringTokenizer.nextToken();
        string2 = Disassembler.isJavaIdentifier(string2) ? string2 : "'" + string2 + "'";
        while (stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken();
            string2 = string2 + "." + (Disassembler.isJavaIdentifier(string3) ? string3 : "'" + string3 + "'");
        }
        return string2;
    }

    private static boolean isJavaIdentifier(String string) {
        if (string.equals("<init>") || string.equals("<clinit>")) {
            return true;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            if (!Character.isJavaIdentifierPart(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    static String convertLiteral(Object object) {
        if (object instanceof String) {
            return Disassembler.convertStringLiteral((String)object);
        }
        if (object instanceof Float) {
            return Disassembler.convertFloatLiteral((Float)object);
        }
        if (object instanceof Double) {
            return Disassembler.convertDoubleLiteral((Double)object);
        }
        if (object instanceof Long) {
            return Disassembler.convertLongLiteral((Long)object);
        }
        return object.toString();
    }

    private static String convertDoubleLiteral(Double d) {
        if (d.isNaN()) {
            return "<NaN>D";
        }
        if (d.isInfinite()) {
            return d > 0.0 ? "<Inf>D" : "-<Inf>D";
        }
        return d + "D";
    }

    private static String convertFloatLiteral(Float f) {
        if (f.isNaN()) {
            return "<NaN>F";
        }
        if (f.isInfinite()) {
            return f.floatValue() > 0.0f ? "<Inf>F" : "-<Inf>F";
        }
        return f + "F";
    }

    private static String convertLongLiteral(Long l) {
        return l + "L";
    }

    private static String convertStringLiteral(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\"");
        int n = 0;
        while (n < string.length()) {
            switch (string.charAt(n)) {
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    break;
                }
                default: {
                    stringBuffer.append(string.charAt(n));
                }
            }
            ++n;
        }
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    private static final void sort(Member[] memberArray) {
        int n = memberArray.length;
        while (--n >= 0) {
            int n2 = 0;
            while (n2 < n) {
                if (memberArray[n2].getName().compareTo(memberArray[n2 + 1].getName()) > 0) {
                    Member member = memberArray[n2];
                    memberArray[n2] = memberArray[n2 + 1];
                    memberArray[n2 + 1] = member;
                }
                ++n2;
            }
        }
    }

    private Disassembler(ClassInfo classInfo, boolean bl, boolean bl2) {
        this.classInfo = classInfo;
        this.optionSortMembers = bl;
        this.optionShowStack = bl2;
    }
}

