/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.CWarning;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CClassType;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CNumericType;
import at.dms.kjc.CStdType;
import at.dms.kjc.CType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.JExpression;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;

public class JCastExpression
extends JExpression {
    protected JExpression expr;
    protected CType dest;

    public CType getType() {
        return this.dest;
    }

    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        this.expr = this.expr.analyse(cExpressionContext);
        try {
            this.dest.checkType(cExpressionContext);
        }
        catch (UnpositionedError unpositionedError) {
            throw unpositionedError.addPosition(this.getTokenReference());
        }
        this.check(cExpressionContext, this.expr.getType().isCastableTo(this.dest), KjcMessages.CAST_CANT, this.expr.getType(), this.dest);
        if (!this.expr.getType().isPrimitive() && this.expr.getType().isAssignableTo(this.dest) && this.expr.getType() != CStdType.Null) {
            cExpressionContext.reportTrouble(new CWarning(this.getTokenReference(), KjcMessages.UNNECESSARY_CAST, this.expr.getType(), this.dest));
        }
        if (this.expr.isConstant()) {
            return this.expr.convertType(this.dest, cExpressionContext);
        }
        if (!this.dest.isAssignableTo(this.expr.getType())) {
            return this.expr.convertType(this.dest, cExpressionContext);
        }
        return this;
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitCastExpression(this, this.expr, this.dest);
    }

    public void genCode(CodeSequence codeSequence, boolean bl) {
        this.setLineNumber(codeSequence);
        this.expr.genCode(codeSequence, false);
        if (this.dest.isNumeric()) {
            ((CNumericType)this.expr.getType()).genCastTo((CNumericType)this.dest, codeSequence);
        } else if (this.dest instanceof CClassType) {
            codeSequence.plantClassRefInstruction(192, ((CClassType)this.dest).getQualifiedName());
        }
        if (bl) {
            codeSequence.plantPopInstruction(this.dest);
        }
    }

    public JCastExpression(TokenReference tokenReference, JExpression jExpression, CType cType) {
        super(tokenReference);
        this.expr = jExpression;
        this.dest = cType;
    }
}

