/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.classfile.PushLiteralInstruction;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CArrayType;
import at.dms.kjc.CClassType;
import at.dms.kjc.CContext;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CStdType;
import at.dms.kjc.CType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.JExpression;
import at.dms.kjc.JTypeNameExpression;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.util.InconsistencyException;

public class JClassExpression
extends JExpression {
    private CType type;
    private JExpression prefix;
    private int bounds;

    public CType getType() {
        return CStdType.Class;
    }

    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        if (this.prefix != null) {
            this.prefix = this.prefix.analyse(new CExpressionContext(cExpressionContext));
            this.check((CContext)cExpressionContext, this.prefix instanceof JTypeNameExpression, KjcMessages.CLASS_BAD_PREFIX, this.prefix);
            this.type = this.prefix.getType();
        }
        if (this.bounds > 0) {
            this.type = new CArrayType(this.type, this.bounds);
        }
        try {
            this.type.checkType(cExpressionContext);
        }
        catch (UnpositionedError unpositionedError) {
            throw unpositionedError.addPosition(this.getTokenReference());
        }
        return this;
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitClassExpression(this, this.type);
    }

    public void genCode(CodeSequence codeSequence, boolean bl) {
        String string;
        this.setLineNumber(codeSequence);
        switch (this.type.getTypeID()) {
            case 9: 
            case 10: {
                codeSequence.plantInstruction(new PushLiteralInstruction(((CClassType)this.type).getQualifiedName().replace('/', '.')));
                codeSequence.plantMethodRefInstruction(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
                return;
            }
            case 11: {
                string = "java/lang/Boolean";
                break;
            }
            case 2: {
                string = "java/lang/Byte";
                break;
            }
            case 4: {
                string = "java/lang/Character";
                break;
            }
            case 8: {
                string = "java/lang/Double";
                break;
            }
            case 7: {
                string = "java/lang/Float";
                break;
            }
            case 5: {
                string = "java/lang/Integer";
                break;
            }
            case 6: {
                string = "java/lang/Long";
                break;
            }
            case 3: {
                string = "java/lang/Short";
                break;
            }
            case 1: {
                string = "java/lang/Void";
                break;
            }
            default: {
                throw new InconsistencyException();
            }
        }
        codeSequence.plantFieldRefInstruction(178, string, "TYPE", CStdType.Class.getSignature());
        if (bl) {
            codeSequence.plantPopInstruction(this.type);
        }
    }

    public JClassExpression(TokenReference tokenReference, CType cType, int n) {
        super(tokenReference);
        this.type = cType;
        this.prefix = null;
        this.bounds = n;
    }

    public JClassExpression(TokenReference tokenReference, JExpression jExpression, int n) {
        super(tokenReference);
        this.type = null;
        this.prefix = jExpression;
        this.bounds = n;
    }
}

