/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CClass;
import at.dms.kjc.CClassType;
import at.dms.kjc.CConstructorContext;
import at.dms.kjc.CContext;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CMethod;
import at.dms.kjc.CMethodNotFoundError;
import at.dms.kjc.CThrowableInfo;
import at.dms.kjc.CType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.JExpression;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.util.Utils;

public class JConstructorCall
extends JExpression {
    private boolean functorIsThis;
    private JExpression[] arguments;
    private CClass clazz;
    private CClass inClass;
    private CMethod method;

    public CMethod getMethod() {
        return this.method;
    }

    final boolean isThisInvoke() {
        return this.functorIsThis;
    }

    public CType getType() {
        return null;
    }

    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        ((CConstructorContext)cExpressionContext.getMethodContext()).setSuperConstructorCalled(false);
        CType[] cTypeArray = new CType[this.arguments.length];
        int n = 0;
        while (n < cTypeArray.length) {
            this.arguments[n] = this.arguments[n].analyse(cExpressionContext);
            cTypeArray[n] = this.arguments[n].getType();
            Utils.assert(cTypeArray[n] != null);
            ++n;
        }
        this.inClass = cExpressionContext.getClassContext().getCClass();
        this.clazz = this.functorIsThis ? cExpressionContext.getClassContext().getCClass() : cExpressionContext.getClassContext().getCClass().getSuperClass();
        Utils.assert(this.clazz != null);
        try {
            this.method = this.clazz.lookupMethod(cExpressionContext.getClassContext().getCClass(), "<init>", cTypeArray);
        }
        catch (UnpositionedError unpositionedError) {
            throw unpositionedError.addPosition(this.getTokenReference());
        }
        this.check((CContext)cExpressionContext, this.method != null, KjcMessages.CONSTRUCTOR_NOTFOUND, this.clazz.getIdent());
        if (this.method.getOwner() != this.clazz) {
            if (this.clazz.isNested()) {
                CType[] cTypeArray2 = new CType[cTypeArray.length + 1];
                System.arraycopy(cTypeArray, 0, cTypeArray2, 0, cTypeArray.length);
                cTypeArray2[cTypeArray.length] = this.clazz.getOwner().getType();
                try {
                    this.method = this.clazz.lookupMethod(cExpressionContext.getClassContext().getCClass(), "<init>", cTypeArray2);
                }
                catch (UnpositionedError unpositionedError) {
                    throw unpositionedError.addPosition(this.getTokenReference());
                }
            }
            if (this.method.getOwner() != this.clazz) {
                throw new CMethodNotFoundError(this.getTokenReference(), null, this.clazz.getType().toString(), cTypeArray);
            }
        }
        CClassType[] cClassTypeArray = this.method.getThrowables();
        int n2 = 0;
        while (n2 < cClassTypeArray.length) {
            if (cClassTypeArray[n2].isCheckedException()) {
                cExpressionContext.getBodyContext().addThrowable(new CThrowableInfo(cClassTypeArray[n2], this));
            }
            ++n2;
        }
        this.check(cExpressionContext, !cExpressionContext.getMethodContext().getCMethod().isStatic(), KjcMessages.BAD_THIS_STATIC);
        cTypeArray = this.method.getParameters();
        n2 = 0;
        while (n2 < this.arguments.length) {
            this.arguments[n2] = this.arguments[n2].convertType(cTypeArray[n2], cExpressionContext);
            ++n2;
        }
        ((CConstructorContext)cExpressionContext.getMethodContext()).setSuperConstructorCalled(true);
        return this;
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitConstructorCall(this, this.functorIsThis, this.arguments);
    }

    public void genCode(CodeSequence codeSequence, boolean bl) {
        this.setLineNumber(codeSequence);
        codeSequence.plantLoadThis();
        CClass cClass = this.method.getOwner();
        if (cClass.isNested() && cClass.hasOuterThis()) {
            this.clazz.genSyntheticParamsFromExplicitSuper(this.inClass.isQualifiedAndAnonymous(), codeSequence);
        }
        int n = 0;
        while (n < this.arguments.length) {
            this.arguments[n].genCode(codeSequence, false);
            ++n;
        }
        this.method.genCode(codeSequence, true);
    }

    public JConstructorCall(TokenReference tokenReference, boolean bl, JExpression[] jExpressionArray) {
        super(tokenReference);
        this.functorIsThis = bl;
        this.arguments = jExpressionArray;
    }
}

