/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.CWarning;
import at.dms.compiler.Compiler;
import at.dms.compiler.JavaStyleComment;
import at.dms.compiler.TokenReference;
import at.dms.kjc.JPackageName;
import at.dms.kjc.JPhylum;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import java.util.Vector;

public class JPackageImport
extends JPhylum {
    private final String name;
    private final JavaStyleComment[] comments;
    private Vector classesUsed;

    public String getName() {
        return this.name;
    }

    public void setClassUsed(String string) {
        if (this.classesUsed == null) {
            this.classesUsed = new Vector();
        }
        this.classesUsed.addElement(string);
    }

    public void analyse(Compiler compiler, JPackageName jPackageName) {
        if (this.getTokenReference() != TokenReference.NO_REF) {
            if (this.classesUsed == null) {
                compiler.reportTrouble(new CWarning(this.getTokenReference(), KjcMessages.UNUSED_PACKAGE_IMPORT, this.name.replace('/', '.'), null));
            } else if (this.classesUsed.size() < 5) {
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n < this.classesUsed.size()) {
                    if (n != 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append((this.name + "/" + (String)this.classesUsed.elementAt(n)).replace('/', '.'));
                    ++n;
                }
                compiler.reportTrouble(new CWarning(this.getTokenReference(), KjcMessages.REPLACE_PACKAGE_IMPORT, this.name.replace('/', '.'), stringBuffer.toString()));
            }
            if (this.name.equals("java/lang")) {
                compiler.reportTrouble(new CWarning(this.getTokenReference(), KjcMessages.IMPORT_JAVA_LANG, (Object)this.name));
            }
            if (this.name.equals(jPackageName.getName())) {
                compiler.reportTrouble(new CWarning(this.getTokenReference(), KjcMessages.IMPORT_CURRENT_PACKAGE, (Object)this.name));
            }
        }
    }

    public void accept(KjcVisitor kjcVisitor) {
        if (this.comments != null) {
            kjcVisitor.visitComments(this.comments);
        }
        kjcVisitor.visitPackageImport(this.name);
    }

    public JPackageImport(TokenReference tokenReference, String string, JavaStyleComment[] javaStyleCommentArray) {
        super(tokenReference);
        this.name = string;
        this.comments = javaStyleCommentArray;
    }
}

