/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;

public class DirectColorModel
extends ColorModel {
    int rmask;
    int gmask;
    int bmask;
    int amask;
    int rshift;
    int bshift;
    int gshift;
    int ashift;
    int rmax;
    int gmax;
    int bmax;
    int amax;

    public final int getAlpha(int n) {
        if (this.amask == 0) {
            return 0;
        }
        return (this.ashift > 0 ? (n & this.amask) >> this.ashift : (n & this.amask) << -this.ashift) * 255 / this.amax;
    }

    public final int getAlphaMask() {
        return this.amask;
    }

    public final int getBlue(int n) {
        if (this.bmask == 0) {
            return 0;
        }
        return (this.bshift > 0 ? (n & this.bmask) >> this.bshift : (n & this.bmask) << -this.bshift) * 255 / this.bmax;
    }

    public final int getBlueMask() {
        return this.bmask;
    }

    public final int getGreen(int n) {
        if (this.gmask == 0) {
            return 0;
        }
        return (this.gshift > 0 ? (n & this.gmask) >> this.gshift : (n & this.gmask) << -this.gshift) * 255 / this.gmax;
    }

    public final int getGreenMask() {
        return this.gmask;
    }

    public final int getRGB(int n) {
        return this.getAlpha(n) << 24 | this.getRed(n) << 16 | this.getGreen(n) << 8 | this.getBlue(n);
    }

    public final int getRed(int n) {
        if (this.rmask == 0) {
            return 0;
        }
        return (this.rshift > 0 ? (n & this.rmask) >> this.rshift : (n & this.rmask) << -this.rshift) * 255 / this.rmax;
    }

    public final int getRedMask() {
        return this.rmask;
    }

    int getShift(int n) {
        int n2 = 0;
        while ((n & 1) == 0) {
            n >>= 1;
            ++n2;
        }
        int n3 = 0;
        while ((n & 1) != 0) {
            n >>= 1;
            ++n3;
        }
        return n2 + (n3 - 8);
    }

    public DirectColorModel(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, 0);
    }

    public DirectColorModel(int n, int n2, int n3, int n4, int n5) {
        super(n);
        this.rmask = n2;
        this.gmask = n3;
        this.bmask = n4;
        this.amask = n5;
        if (n2 != 0) {
            this.rshift = this.getShift(n2);
            int n6 = this.rmax = this.rshift > 0 ? (0xFFFFFFFF & n2) >> this.rshift : (0xFFFFFFFF & n2) << -this.rshift;
        }
        if (n3 != 0) {
            this.gshift = this.getShift(n3);
            int n7 = this.gmax = this.gshift > 0 ? (0xFFFFFFFF & n3) >> this.gshift : (0xFFFFFFFF & n3) << -this.gshift;
        }
        if (this.bshift != 0) {
            this.bshift = this.getShift(n4);
            int n8 = this.bmax = this.bshift > 0 ? (0xFFFFFFFF & n4) >> this.bshift : (0xFFFFFFFF & n4) << -this.bshift;
        }
        if (n5 != 0) {
            this.ashift = this.getShift(n5);
            this.amax = this.ashift > 0 ? (0xFFFFFFFF & n5) >> this.ashift : (0xFFFFFFFF & n5) << -this.ashift;
        }
    }
}

