/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeSet;

public class Properties
extends Hashtable {
    private static final long serialVersionUID = 4112578634029874840L;
    protected Properties defaults;
    private StringBuffer key;
    private StringBuffer value;

    private static String escape(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '!': 
                case '#': {
                    if (n == 0) {
                        stringBuffer.append("\\");
                    }
                    stringBuffer.append(c);
                    break;
                }
                case ' ': 
                case ':': 
                case '=': {
                    if (!bl) {
                        stringBuffer.append(c);
                        break;
                    }
                }
                case '\\': {
                    stringBuffer.append("\\" + c);
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        stringBuffer.append("\\u");
                        stringBuffer.append(Character.forDigit(c >> 12 & 0xF, 16));
                        stringBuffer.append(Character.forDigit(c >> 8 & 0xF, 16));
                        stringBuffer.append(Character.forDigit(c >> 4 & 0xF, 16));
                        stringBuffer.append(Character.forDigit(c & 0xF, 16));
                        break;
                    }
                    stringBuffer.append(c);
                    break;
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getProperty(String string) {
        Object object = super.get(string);
        if (object != null) {
            return (String)object;
        }
        if (this.defaults != null) {
            return this.defaults.getProperty(string);
        }
        return null;
    }

    public String getProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public Object setProperty(String string, String string2) {
        return super.put(string, string2);
    }

    public void list(PrintStream printStream) {
        this.list(new PrintWriter(printStream, true));
    }

    public void list(PrintWriter printWriter) {
        try {
            this.save(printWriter, "Properties list");
        }
        catch (IOException iOException) {
            System.err.println("unable to list properties");
        }
    }

    public Enumeration propertyNames() {
        TreeSet treeSet = new TreeSet();
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            treeSet.add(enumeration.nextElement());
        }
        if (this.defaults != null) {
            enumeration = this.defaults.keys();
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                if (treeSet.contains(object)) continue;
                treeSet.add(object);
            }
        }
        return Collections.enumeration(treeSet);
    }

    public synchronized void load(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 16);
        while (this.readKeyAndValue(pushbackInputStream)) {
            this.put(this.key.toString(), this.value.toString());
        }
        this.key = null;
        this.value = null;
    }

    /*
     * Unable to fully structure code
     */
    private boolean readKeyAndValue(PushbackInputStream var1_1) throws IOException {
        block21: while (true) {
            if ((var2_2 = var1_1.read()) != -1 && var2_2 <= 32) {
                continue;
            }
            switch (var2_2) {
                case 33: 
                case 35: {
                    do {
                        if ((var2_2 = var1_1.read()) == -1) continue block21;
                    } while (var2_2 != 10);
                    break;
                }
                case -1: {
                    return false;
                }
                default: {
                    this.key = new StringBuffer();
                    this.value = new StringBuffer();
                    var3_3 = false;
                    while (true) {
                        switch (var2_2) {
                            case 58: 
                            case 61: {
                                ** GOTO lbl44
                            }
                            case 13: {
                                var2_2 = var1_1.read();
                                switch (var2_2) {
                                    case 10: {
                                        break;
                                    }
                                    case -1: {
                                        return true;
                                    }
                                    default: {
                                        var1_1.unread(var2_2);
                                        ** GOTO lbl44
                                    }
                                }
                            }
                            case -1: 
                            case 10: {
                                return true;
                            }
                            default: {
                                if (var2_2 > 32) ** GOTO lbl36
                                var3_3 = true;
                                if (true) ** GOTO lbl44
lbl36:
                                // 1 sources

                                var1_1.unread(var2_2);
                                this.key.append((char)Properties.getEscapedChar(var1_1));
                                var2_2 = var1_1.read();
                            }
                        }
                    }
                    block24: while (true) {
                        if (var2_2 == -1 || var2_2 == 10) {
                            return true;
                        }
lbl44:
                        // 5 sources

                        while (true) {
                            if ((var2_2 = var1_1.read()) <= 32) continue block24;
                            if (!var3_3 || var2_2 != 61 && var2_2 != 58) break block24;
                            var3_3 = false;
                        }
                        break;
                    }
                    while (true) {
                        switch (var2_2) {
                            case 13: {
                                var2_2 = var1_1.read();
                                switch (var2_2) {
                                    case -1: {
                                        this.value.append('\r');
                                    }
                                    case 10: {
                                        return true;
                                    }
                                }
                                var1_1.unread(var2_2);
                                this.value.append('\r');
                                break;
                            }
                            case -1: 
                            case 10: {
                                return true;
                            }
                            default: {
                                var1_1.unread(var2_2);
                                this.value.append((char)Properties.getEscapedChar(var1_1));
                                break;
                            }
                        }
                        var2_2 = var1_1.read();
                    }
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static int getEscapedChar(PushbackInputStream var0) throws IOException {
        var1_1 = var0.read();
        switch (var1_1) {
            case 92: {
                var1_1 = var0.read();
                switch (var1_1) {
                    case 13: {
                        var1_1 = var0.read();
                        switch (var1_1) {
                            default: {
                                var0.unread(var1_1);
                            }
                            case -1: {
                                var0.unread(13);
                                return 92;
                            }
                            case 10: 
                        }
                    }
                    case 10: {
                        while ((var1_1 = var0.read()) != -1 && var1_1 <= 32) {
                        }
                        var0.unread(var1_1);
                        return Properties.getEscapedChar(var0);
                    }
                    case 110: {
                        return 10;
                    }
                    case 114: {
                        return 13;
                    }
                    case 116: {
                        return 9;
                    }
                    case 117: {
                        var2_2 = new int[4];
                        var5_3 = 0;
                        var3_4 = 0;
                        while (var3_4 < 4) {
                            var2_2[var3_4] = var0.read();
                            if (var2_2[var3_4] != -1 && (var4_5 = Character.digit((char)var2_2[var3_4++], 16)) != -1) {
                                var5_3 = var5_3 << 4 | var4_5;
                                continue;
                            }
                            ** GOTO lbl38
                        }
                        return var5_3;
lbl-1000:
                        // 1 sources

                        {
                            var0.unread(var2_2[--var3_4]);
lbl38:
                            // 2 sources

                            ** while (var3_4 > 0)
                        }
lbl39:
                        // 1 sources

                        return 117;
                    }
                    case -1: {
                        return 92;
                    }
                }
                return var1_1;
            }
            case 13: {
                var1_1 = var0.read();
                switch (var1_1) {
                    default: {
                        var0.unread(var1_1);
                    }
                    case -1: {
                        return 13;
                    }
                    case 10: 
                }
                break;
            }
        }
        return var1_1;
    }

    public synchronized void save(OutputStream outputStream, String string) {
        try {
            this.store(outputStream, string);
        }
        catch (IOException iOException) {
            System.err.println("Unable to save properties: " + string);
        }
    }

    public synchronized void store(OutputStream outputStream, String string) throws IOException {
        this.save(new PrintWriter(outputStream, true), string);
    }

    private synchronized void save(PrintWriter printWriter, String string) throws IOException {
        if (string != null) {
            printWriter.println("# " + Properties.escape(string, false));
        }
        Enumeration enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            printWriter.println(Properties.escape(string2, true) + "=" + Properties.escape(this.getProperty(string2), false));
        }
        printWriter.flush();
    }

    public Properties() {
        this(null);
    }

    public Properties(Properties properties) {
        this.defaults = properties;
    }
}

