/*
 * Decompiled with CFR 0.152.
 */
package at.dms.dis;

import at.dms.classfile.ClassPath;
import at.dms.compiler.CompilerMessages;
import at.dms.compiler.UnpositionedError;
import at.dms.dis.Constants;
import at.dms.dis.DisMessages;
import at.dms.dis.DisOptions;
import at.dms.dis.Disassembler;
import at.dms.util.Message;
import at.dms.util.MessageDescription;

public class Main
implements Constants {
    private DisOptions options;

    public static void main(String[] stringArray) {
        boolean bl = new Main().run(stringArray);
        System.exit(bl ? 0 : 1);
    }

    public boolean run(String[] stringArray) {
        if (!this.parseArguments(stringArray)) {
            return false;
        }
        ClassPath.init(this.options.classpath);
        String[] stringArray2 = this.options.nonOptions;
        if (stringArray2.length == 0) {
            this.options.usage();
            this.inform(CompilerMessages.NO_INPUT_FILE);
            return false;
        }
        boolean bl = false;
        int n = 0;
        while (n < stringArray2.length) {
            if (this.options.verbose) {
                this.inform(DisMessages.PROCESSING, new String[]{stringArray2[n]});
            }
            try {
                this.disassembleClass(stringArray2[n]);
            }
            catch (UnpositionedError unpositionedError) {
                this.inform("Error: " + unpositionedError.getMessage());
                bl = true;
            }
            ++n;
        }
        return !bl;
    }

    private boolean parseArguments(String[] stringArray) {
        this.options = new DisOptions();
        return this.options.parseCommandLine(stringArray);
    }

    private void disassembleClass(String string) throws UnpositionedError {
        Disassembler.disassemble(string, this.options.destination, this.options);
    }

    public void inform(Message message) {
        this.inform(message.getMessage());
    }

    public void inform(MessageDescription messageDescription, Object[] objectArray) {
        this.inform(new Message(messageDescription, objectArray));
    }

    public void inform(MessageDescription messageDescription) {
        this.inform(messageDescription, null);
    }

    private void inform(String string) {
        System.err.println(string);
        System.err.flush();
    }

    private Main() {
    }
}

