/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.classfile.PushLiteralInstruction;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CStdType;
import at.dms.kjc.CType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.JByteLiteral;
import at.dms.kjc.JCharLiteral;
import at.dms.kjc.JDoubleLiteral;
import at.dms.kjc.JExpression;
import at.dms.kjc.JIntLiteral;
import at.dms.kjc.JLiteral;
import at.dms.kjc.JLongLiteral;
import at.dms.kjc.JShortLiteral;
import at.dms.kjc.JStringLiteral;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.util.InconsistencyException;

public class JFloatLiteral
extends JLiteral {
    private static final int ZERO_BITS = Float.floatToIntBits(0.0f);
    private final float value;

    private boolean isZeroLiteral(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            switch (cArray[n]) {
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return false;
                }
                case 'E': 
                case 'e': {
                    return true;
                }
            }
            ++n;
        }
        return true;
    }

    public CType getType() {
        return CStdType.Float;
    }

    public float floatValue() {
        return this.value;
    }

    public boolean isDefault() {
        return Float.floatToIntBits(this.value) == ZERO_BITS;
    }

    public JExpression convertType(CType cType, CExpressionContext cExpressionContext) {
        switch (cType.getTypeID()) {
            case 2: {
                return new JByteLiteral(this.getTokenReference(), (byte)this.value);
            }
            case 3: {
                return new JShortLiteral(this.getTokenReference(), (short)this.value);
            }
            case 4: {
                return new JCharLiteral(this.getTokenReference(), (char)this.value);
            }
            case 5: {
                return new JIntLiteral(this.getTokenReference(), (int)this.value);
            }
            case 6: {
                return new JLongLiteral(this.getTokenReference(), (long)this.value);
            }
            case 7: {
                return this;
            }
            case 8: {
                return new JDoubleLiteral(this.getTokenReference(), this.value);
            }
            case 9: {
                if (cType != CStdType.String) {
                    throw new InconsistencyException("cannot convert from float to " + cType);
                }
                return new JStringLiteral(this.getTokenReference(), "" + this.value);
            }
        }
        throw new InconsistencyException("cannot convert from float to " + cType);
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitFloatLiteral(this.value);
    }

    public void genCode(CodeSequence codeSequence, boolean bl) {
        if (!bl) {
            this.setLineNumber(codeSequence);
            codeSequence.plantInstruction(new PushLiteralInstruction(this.value));
        }
    }

    public JFloatLiteral(TokenReference tokenReference, String string) throws PositionedError {
        super(tokenReference);
        try {
            this.value = Float.valueOf(string).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new PositionedError(tokenReference, KjcMessages.INVALID_FLOAT_LITERAL, (Object)string);
        }
        if (Float.isInfinite(this.value)) {
            throw new PositionedError(tokenReference, KjcMessages.FLOAT_LITERAL_OVERFLOW, (Object)string);
        }
        if (this.value == 0.0f && !this.isZeroLiteral(string)) {
            throw new PositionedError(tokenReference, KjcMessages.FLOAT_LITERAL_UNDERFLOW, (Object)string);
        }
    }

    public JFloatLiteral(TokenReference tokenReference, float f) {
        super(tokenReference);
        this.value = f;
    }
}

