/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.JavaStyleComment;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CBodyContext;
import at.dms.kjc.CContext;
import at.dms.kjc.CLabeledContext;
import at.dms.kjc.CodeLabel;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.JLoopStatement;
import at.dms.kjc.JStatement;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;

public class JLabeledStatement
extends JStatement {
    private String label;
    private JStatement body;
    private CodeLabel endLabel;

    String getLabel() {
        return this.label;
    }

    public void analyse(CBodyContext cBodyContext) throws PositionedError {
        this.check((CContext)cBodyContext, cBodyContext.getLabeledStatement(this.label) == null, KjcMessages.LABEL_ALREADY_EXISTS, this.label);
        CLabeledContext cLabeledContext = new CLabeledContext(cBodyContext, this);
        this.body.analyse(cLabeledContext);
        cLabeledContext.close(this.getTokenReference());
    }

    public JStatement getTargetStatement() {
        if (this.body instanceof JLoopStatement) {
            return this.body;
        }
        return this;
    }

    public void accept(KjcVisitor kjcVisitor) {
        super.accept(kjcVisitor);
        kjcVisitor.visitLabeledStatement(this, this.label, this.body);
    }

    public void genCode(CodeSequence codeSequence) {
        this.setLineNumber(codeSequence);
        this.endLabel = new CodeLabel();
        this.body.genCode(codeSequence);
        codeSequence.plantLabel(this.endLabel);
        this.endLabel = null;
    }

    public CodeLabel getBreakLabel() {
        return this.endLabel;
    }

    public JLabeledStatement(TokenReference tokenReference, String string, JStatement jStatement, JavaStyleComment[] javaStyleCommentArray) {
        super(tokenReference, javaStyleCommentArray);
        this.label = string;
        this.body = jStatement;
    }
}

