/*
 * Decompiled with CFR 0.152.
 */
package kaffe.rmi.server;

import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ObjID;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.Skeleton;
import kaffe.rmi.server.RMIHashes;
import kaffe.rmi.server.UnicastConnection;
import kaffe.rmi.server.UnicastConnectionManager;
import kaffe.rmi.server.UnicastRef;
import kaffe.rmi.server.UnicastRemoteCall;
import kaffe.rmi.server.UnicastRemoteStub;
import kaffe.rmi.server.UnicastServer;
import kaffe.util.LongHashtable;
import kaffe.util.NotImplemented;

public class UnicastServerRef
extends UnicastRef {
    private static final Class[] stubprototype = new Class[]{class$Ljava$rmi$server$RemoteRef != null ? class$Ljava$rmi$server$RemoteRef : (class$Ljava$rmi$server$RemoteRef = UnicastServerRef.class$("java.rmi.server.RemoteRef"))};
    Remote myself;
    private Skeleton skel;
    private RemoteStub stub;
    private LongHashtable methods;
    private static /* synthetic */ Class class$Ljava$rmi$server$RemoteRef;

    public RemoteStub exportObject(Remote remote) throws RemoteException {
        if (this.myself == null) {
            this.myself = remote;
            Class<?> clazz = remote.getClass();
            this.stub = (RemoteStub)this.getHelperClass(clazz, "_Stub");
            if (this.stub == null) {
                throw new RemoteException("failed to export: " + clazz);
            }
            this.skel = (Skeleton)this.getHelperClass(clazz, "_Skel");
            this.buildMethodHash(remote.getClass());
            UnicastServer.exportObject(this);
        }
        return this.stub;
    }

    private Object getHelperClass(Class clazz, String string) {
        try {
            String string2 = clazz.getName();
            Class<?> clazz2 = Class.forName(string2 + string);
            if (string.equals("_Stub")) {
                try {
                    Constructor<?> constructor = clazz2.getConstructor(stubprototype);
                    return constructor.newInstance(this);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
                RemoteStub remoteStub = (RemoteStub)clazz2.newInstance();
                UnicastRemoteStub.setStubRef(remoteStub, this);
                return remoteStub;
            }
            return clazz2.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    public String getClientHost() throws ServerNotActiveException {
        throw new NotImplemented();
    }

    private void buildMethodHash(Class clazz) {
        this.methods = new LongHashtable();
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            if (!methodArray[n].getDeclaringClass().getName().startsWith("java.")) {
                long l = RMIHashes.getMethodHash(methodArray[n]);
                this.methods.put(l, (Object)methodArray[n]);
            }
            ++n;
        }
    }

    public Object incomingMessageCall(UnicastConnection unicastConnection, int n, long l) throws Exception {
        if (n == -1) {
            Method method = (Method)this.methods.get(l);
            if (method == null) {
                throw new NoSuchMethodException();
            }
            ObjectInputStream objectInputStream = unicastConnection.getObjectInputStream();
            int n2 = method.getParameterTypes().length;
            Object[] objectArray = new Object[n2];
            int n3 = 0;
            while (n3 < n2) {
                try {
                    objectArray[n3] = objectInputStream.readObject();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw exception;
                }
                ++n3;
            }
            return method.invoke((Object)this.myself, objectArray);
        }
        if (this.skel == null) {
            throw new NoSuchMethodException();
        }
        UnicastRemoteCall unicastRemoteCall = new UnicastRemoteCall(unicastConnection);
        this.skel.dispatch(this.myself, unicastRemoteCall, n, l);
        return unicastRemoteCall.returnValue();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public UnicastServerRef(ObjID objID, int n, RMIServerSocketFactory rMIServerSocketFactory) {
        super(objID);
        this.manager = UnicastConnectionManager.getInstance(n, rMIServerSocketFactory);
    }
}

