/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.AccessorContainer;
import at.dms.classfile.AccessorTransformer;
import at.dms.classfile.AsciiConstant;
import at.dms.classfile.Attribute;
import at.dms.classfile.AttributeList;
import at.dms.classfile.BadAccessorException;
import at.dms.classfile.ClassFileFormatException;
import at.dms.classfile.CodeEnv;
import at.dms.classfile.ConstantPool;
import at.dms.classfile.HandlerInfo;
import at.dms.classfile.Instruction;
import at.dms.classfile.InstructionIO;
import at.dms.classfile.LineNumberInfo;
import at.dms.classfile.LineNumberTable;
import at.dms.classfile.LocalVariableInfo;
import at.dms.classfile.LocalVariableTable;
import at.dms.util.InconsistencyException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CodeInfo
extends Attribute {
    public static final CodeInfo DUM_INFO = new CodeInfo();
    private static AsciiConstant attr = new AsciiConstant("Code");
    private Instruction[] instructions;
    private HandlerInfo[] handlers;
    private int paramCnt = -1;
    private int maxStack = -1;
    private int maxLocals = -1;
    private int codeLength = -1;
    private AttributeList attributes;

    private void compactInstructions() {
        Instruction[] instructionArray = this.instructions;
        int n = 0;
        int n2 = 0;
        while (n2 < instructionArray.length) {
            if (instructionArray[n2] != null) {
                ++n;
            }
            ++n2;
        }
        this.instructions = new Instruction[n];
        n2 = 0;
        int n3 = 0;
        while (n2 < instructionArray.length) {
            if (instructionArray[n2] != null) {
                this.instructions[n3++] = instructionArray[n2];
            }
            ++n2;
        }
    }

    public void transformAccessors(AccessorTransformer accessorTransformer) throws BadAccessorException {
        int n = 0;
        while (n < this.instructions.length) {
            if (this.instructions[n] instanceof AccessorContainer) {
                ((AccessorContainer)((Object)this.instructions[n])).transformAccessors(accessorTransformer);
            }
            ++n;
        }
        AccessorContainer[] accessorContainerArray = this.handlers;
        if (accessorContainerArray != null) {
            n = 0;
            while (n < accessorContainerArray.length) {
                accessorContainerArray[n].transformAccessors(accessorTransformer);
                ++n;
            }
        }
        if ((accessorContainerArray = this.getLineNumbers()) != null) {
            n = 0;
            while (n < accessorContainerArray.length) {
                accessorContainerArray[n].transformAccessors(accessorTransformer);
                ++n;
            }
        }
        if ((accessorContainerArray = this.getLocalVariables()) != null) {
            n = 0;
            while (n < accessorContainerArray.length) {
                accessorContainerArray[n].transformAccessors(accessorTransformer);
                ++n;
            }
        }
    }

    int getTag() {
        return 3;
    }

    int getSize() {
        if (this.codeLength == -1) {
            throw new InconsistencyException("code length not yet computed");
        }
        int n = 14 + this.codeLength + 2 + 2 + 8 * this.handlers.length + this.attributes.getSize();
        return n;
    }

    public Instruction[] getInstructions() {
        return this.instructions;
    }

    public HandlerInfo[] getHandlers() {
        return this.handlers;
    }

    public LineNumberInfo[] getLineNumbers() {
        Attribute attribute = this.attributes.get(5);
        return attribute == null ? null : ((LineNumberTable)attribute).getLineNumbers();
    }

    public LocalVariableInfo[] getLocalVariables() {
        Attribute attribute = this.attributes.get(6);
        return attribute == null ? null : ((LocalVariableTable)attribute).getLocalVariables();
    }

    public int getCodeLength() {
        return this.codeLength;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public void setParameterCount(int n) {
        this.paramCnt = n;
    }

    public int getParameterCount() {
        return this.paramCnt;
    }

    void setCodeLength(int n) {
        this.codeLength = n;
    }

    void setMaxStack(int n) {
        this.maxStack = n;
    }

    void setMaxLocals(int n) {
        this.maxLocals = n;
    }

    void resolveConstants(ConstantPool constantPool) throws ClassFileFormatException {
        constantPool.addItem(attr);
        int n = 0;
        while (n < this.instructions.length) {
            this.instructions[n].resolveConstants(constantPool);
            ++n;
        }
        n = 0;
        while (n < this.handlers.length) {
            this.handlers[n].resolveConstants(constantPool);
            ++n;
        }
        this.attributes.resolveConstants(constantPool);
        CodeEnv.check(this);
    }

    void write(ConstantPool constantPool, DataOutput dataOutput) throws IOException, ClassFileFormatException {
        dataOutput.writeShort(attr.getIndex());
        dataOutput.writeInt(this.getSize() - 6);
        if (this.maxStack == -1) {
            throw new ClassFileFormatException("maxStack not set");
        }
        if (this.maxLocals == -1) {
            throw new ClassFileFormatException("maxLocals not set");
        }
        if (this.paramCnt == -1) {
            throw new ClassFileFormatException("paramCnt not set");
        }
        dataOutput.writeShort(this.maxStack);
        dataOutput.writeShort(Math.max(this.paramCnt, this.maxLocals));
        dataOutput.writeInt(this.codeLength);
        int n = 0;
        while (n < this.instructions.length) {
            this.instructions[n].write(constantPool, dataOutput);
            ++n;
        }
        dataOutput.writeShort(this.handlers.length);
        n = 0;
        while (n < this.handlers.length) {
            this.handlers[n].write(constantPool, dataOutput);
            ++n;
        }
        this.attributes.write(constantPool, dataOutput);
    }

    public CodeInfo(Instruction[] instructionArray, HandlerInfo[] handlerInfoArray, LineNumberInfo[] lineNumberInfoArray, LocalVariableInfo[] localVariableInfoArray) {
        this.instructions = instructionArray;
        this.handlers = handlerInfoArray == null ? new HandlerInfo[]{} : handlerInfoArray;
        this.attributes = new AttributeList(lineNumberInfoArray != null ? new LineNumberTable(lineNumberInfoArray) : null, localVariableInfoArray != null ? new LocalVariableTable(localVariableInfoArray) : null);
    }

    public CodeInfo(DataInput dataInput, ConstantPool constantPool) throws IOException, ClassFileFormatException {
        dataInput.readInt();
        this.maxStack = (short)dataInput.readUnsignedShort();
        this.maxLocals = (short)dataInput.readUnsignedShort();
        this.instructions = InstructionIO.read(dataInput, constantPool);
        this.handlers = new HandlerInfo[dataInput.readUnsignedShort()];
        int n = 0;
        while (n < this.handlers.length) {
            this.handlers[n] = new HandlerInfo(dataInput, constantPool, this.instructions);
            ++n;
        }
        this.attributes = new AttributeList(dataInput, constantPool, this.instructions);
        this.compactInstructions();
    }

    protected CodeInfo() {
    }
}

