/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.AsciiConstant;
import at.dms.classfile.Attribute;
import at.dms.classfile.ClassFileFormatException;
import at.dms.classfile.ConstantPool;
import at.dms.classfile.DoubleConstant;
import at.dms.classfile.FloatConstant;
import at.dms.classfile.IntegerConstant;
import at.dms.classfile.LongConstant;
import at.dms.classfile.PooledConstant;
import at.dms.classfile.StringConstant;
import at.dms.util.InconsistencyException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ConstantValueAttribute
extends Attribute {
    private static AsciiConstant attr = new AsciiConstant("ConstantValue");
    private PooledConstant value;

    int getTag() {
        return 2;
    }

    int getSize() {
        return 8;
    }

    Object getLiteral() {
        return this.value.getLiteral();
    }

    void resolveConstants(ConstantPool constantPool) {
        constantPool.addItem(attr);
        constantPool.addItem(this.value);
    }

    void write(ConstantPool constantPool, DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(attr.getIndex());
        dataOutput.writeInt(2);
        dataOutput.writeShort(this.value.getIndex());
    }

    public ConstantValueAttribute(Object object) {
        if (object instanceof Integer) {
            this.value = new IntegerConstant((Integer)object);
        } else if (object instanceof Float) {
            this.value = new FloatConstant(((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.value = new DoubleConstant((Double)object);
        } else if (object instanceof Long) {
            this.value = new LongConstant((Long)object);
        } else if (object instanceof String) {
            this.value = new StringConstant((String)object);
        } else {
            throw new InconsistencyException("bad object type " + object.getClass());
        }
    }

    public ConstantValueAttribute(DataInput dataInput, ConstantPool constantPool) throws IOException, ClassFileFormatException {
        if (dataInput.readInt() != 2) {
            throw new ClassFileFormatException("bad attribute length");
        }
        this.value = constantPool.getEntryAt(dataInput.readUnsignedShort());
    }
}

