/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CClassType;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CLineError;
import at.dms.kjc.CType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.JArrayLengthExpression;
import at.dms.kjc.JExpression;
import at.dms.kjc.JFieldAccessExpression;
import at.dms.kjc.JLocalVariable;
import at.dms.kjc.JLocalVariableExpression;
import at.dms.kjc.JTypeNameExpression;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.util.InconsistencyException;
import at.dms.util.Utils;

public class JNameExpression
extends JExpression {
    private JExpression prefix;
    private String ident;

    public CType getType() {
        return null;
    }

    public String getName() {
        return this.ident;
    }

    public JExpression getPrefix() {
        return this.prefix;
    }

    public String getQualifiedName() {
        String string = this.getName();
        if (this.prefix == null) {
            return string;
        }
        if (this.prefix instanceof JNameExpression) {
            return ((JNameExpression)this.prefix).getQualifiedName() + "." + string;
        }
        if (this.prefix instanceof JTypeNameExpression) {
            return (JNameExpression)this.prefix + "." + string;
        }
        return string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.prefix != null) {
            stringBuffer.append(this.prefix.toString());
            stringBuffer.append(".");
        }
        stringBuffer.append(this.ident);
        return stringBuffer.toString();
    }

    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        try {
            if (this.prefix == null) {
                JLocalVariable jLocalVariable = cExpressionContext.lookupLocalVariable(this.ident);
                if (jLocalVariable != null) {
                    return new JLocalVariableExpression(this.getTokenReference(), jLocalVariable).analyse(cExpressionContext);
                }
                if (cExpressionContext.lookupField(cExpressionContext.getClassContext().getCClass(), this.ident) != null) {
                    return this.createClassField(this.getTokenReference(), this.ident).analyse(cExpressionContext);
                }
                JExpression jExpression = cExpressionContext.getBlockContext().lookupOuterLocalVariable(this.getTokenReference(), this.ident);
                if (jExpression != null) {
                    return jExpression.analyse(cExpressionContext);
                }
                if (cExpressionContext.getClassContext().lookupOuterField(cExpressionContext.getClassContext().getCClass(), this.ident) != null) {
                    return this.createClassField(this.getTokenReference(), this.ident).analyse(cExpressionContext);
                }
                try {
                    CClassType cClassType = CClassType.lookup(this.ident);
                    cClassType.checkType(cExpressionContext);
                    return new JTypeNameExpression(this.getTokenReference(), cClassType);
                }
                catch (UnpositionedError unpositionedError) {
                    throw new CLineError(this.getTokenReference(), KjcMessages.VAR_UNKNOWN, (Object)this.ident);
                }
            }
            Utils.assert(this.prefix != null);
            try {
                this.prefix = this.prefix.analyse(cExpressionContext);
            }
            catch (CLineError cLineError) {
                if (cLineError.hasDescription(KjcMessages.VAR_UNKNOWN)) {
                    return this.convertToPackageName(cLineError, cExpressionContext);
                }
                throw cLineError;
            }
            if (this.prefix instanceof JTypeNameExpression) {
                if (((JTypeNameExpression)this.prefix).getClassType().getCClass().lookupField(cExpressionContext.getClassContext().getCClass(), this.ident) != null) {
                    return this.createClassField(this.getTokenReference(), this.prefix, this.ident).analyse(cExpressionContext);
                }
                return new JTypeNameExpression(this.getTokenReference(), ((JTypeNameExpression)this.prefix).getQualifiedName() + "/" + this.ident);
            }
            if (this.ident == "length" && this.prefix.getType().isArrayType()) {
                return new JArrayLengthExpression(this.getTokenReference(), this.prefix);
            }
            return this.createClassField(this.getTokenReference(), this.prefix, this.ident).analyse(cExpressionContext);
        }
        catch (UnpositionedError unpositionedError) {
            throw unpositionedError.addPosition(this.getTokenReference());
        }
    }

    private JExpression convertToPackageName(CLineError cLineError, CExpressionContext cExpressionContext) throws PositionedError {
        try {
            if (this.prefix instanceof JNameExpression) {
                CClassType cClassType = CClassType.lookup(((JNameExpression)this.prefix).getName() + "/" + this.ident);
                cClassType.checkType(cExpressionContext);
                return new JTypeNameExpression(this.getTokenReference(), cClassType);
            }
            if (!(this.prefix instanceof JTypeNameExpression)) {
                throw new CLineError(this.getTokenReference(), KjcMessages.VAR_UNKNOWN, (Object)this.ident);
            }
            return this.prefix;
        }
        catch (UnpositionedError unpositionedError) {
            this.ident = ((JNameExpression)this.prefix).getName() + "/" + this.ident;
            throw new CLineError(this.getTokenReference(), KjcMessages.VAR_UNKNOWN, (Object)this.ident);
        }
    }

    protected JFieldAccessExpression createClassField(TokenReference tokenReference, JExpression jExpression, String string) {
        return new JFieldAccessExpression(tokenReference, jExpression, string);
    }

    protected JFieldAccessExpression createClassField(TokenReference tokenReference, String string) {
        return new JFieldAccessExpression(tokenReference, string);
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitNameExpression(this, this.prefix, this.ident);
    }

    public void genCode(CodeSequence codeSequence, boolean bl) {
        throw new InconsistencyException();
    }

    public JNameExpression(TokenReference tokenReference, String string) {
        super(tokenReference);
        this.ident = string;
        Utils.assert(string.indexOf(46) == -1);
        Utils.assert(string.indexOf(47) == -1);
    }

    public JNameExpression(TokenReference tokenReference, JExpression jExpression, String string) {
        super(tokenReference);
        this.prefix = jExpression;
        this.ident = string;
        Utils.assert(string.indexOf(46) == -1);
        Utils.assert(string.indexOf(47) == -1);
    }

    public JNameExpression(TokenReference tokenReference, String string, boolean bl) {
        super(tokenReference);
        int n = Math.max(string.lastIndexOf("."), string.lastIndexOf("/"));
        if (bl && n >= 0) {
            this.prefix = new JNameExpression(tokenReference, string.substring(0, n), true);
            this.ident = string.substring(n + 1, string.length()).intern();
        } else {
            this.ident = string.intern();
        }
    }
}

