/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.classfile.MethodInfo;
import at.dms.kjc.CClass;
import at.dms.kjc.CClassType;
import at.dms.kjc.CMethod;
import at.dms.kjc.CType;

public class CBinaryMethod
extends CMethod {
    private static CType buildReturnType(MethodInfo methodInfo) {
        CType[] cTypeArray = CType.parseMethodSignature(methodInfo.getSignature());
        return cTypeArray[cTypeArray.length - 1];
    }

    private static CType[] buildParameterTypes(MethodInfo methodInfo) {
        CType[] cTypeArray = CType.parseMethodSignature(methodInfo.getSignature());
        CType[] cTypeArray2 = new CType[cTypeArray.length - 1];
        cTypeArray2 = new CType[cTypeArray.length - 1];
        int n = 0;
        while (n < cTypeArray2.length) {
            cTypeArray2[n] = cTypeArray[n];
            ++n;
        }
        return cTypeArray2;
    }

    private static CClassType[] buildExceptionTypes(MethodInfo methodInfo) {
        String[] stringArray = methodInfo.getExceptions();
        if (stringArray == null) {
            return new CClassType[0];
        }
        CClassType[] cClassTypeArray = new CClassType[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            cClassTypeArray[n] = CClassType.lookup(stringArray[n]);
            ++n;
        }
        return cClassTypeArray;
    }

    public boolean equals(CMethod cMethod) {
        CClass cClass = this.getOwner();
        if (!(this.isConstructor() && cMethod.isConstructor() && cClass.isNested() && cClass.hasOuterThis() && !(cMethod instanceof CBinaryMethod))) {
            return super.equals(cMethod);
        }
        CType[] cTypeArray = this.getParameters();
        CType[] cTypeArray2 = cMethod.getParameters();
        if (!this.getOwner().equals(cMethod.getOwner())) {
            return false;
        }
        if (this.getIdent() != cMethod.getIdent()) {
            return false;
        }
        if (cTypeArray.length != cTypeArray2.length - 1) {
            return false;
        }
        int n = 1;
        while (n < cTypeArray.length) {
            if (!cTypeArray[n].equals(cTypeArray2[n - 1])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isApplicableTo(String string, CType[] cTypeArray) {
        CClass cClass = this.getOwner();
        if (!(this.isConstructor() && string == "<init>" && cClass.isNested() && cClass.hasOuterThis())) {
            return super.isApplicableTo(string, cTypeArray);
        }
        CType[] cTypeArray2 = this.getParameters();
        if (string != this.getIdent()) {
            return false;
        }
        if (cTypeArray.length + 1 != cTypeArray2.length) {
            return false;
        }
        int n = 0;
        while (n < cTypeArray.length) {
            if (!cTypeArray[n].isAssignableTo(cTypeArray2[n + 1])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isMoreSpecificThan(CMethod cMethod) {
        CClass cClass = this.getOwner();
        if (!(this.isConstructor() && cMethod.isConstructor() && cClass.isNested() && cClass.hasOuterThis() && !(cMethod instanceof CBinaryMethod))) {
            return super.isMoreSpecificThan(cMethod);
        }
        CType[] cTypeArray = this.getParameters();
        CType[] cTypeArray2 = cMethod.getParameters();
        if (!this.getOwner().getType().isAssignableTo(cMethod.getOwner().getType())) {
            return false;
        }
        if (cTypeArray.length != cTypeArray2.length + 1) {
            return false;
        }
        int n = 0;
        while (n < cTypeArray2.length) {
            if (!cTypeArray[n + 1].isAssignableTo(cTypeArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean hasSameSignature(CMethod cMethod) {
        CType[] cTypeArray;
        CClass cClass = this.getOwner();
        if (!(this.isConstructor() && cMethod.isConstructor() && cClass.isNested() && cClass.hasOuterThis() && !(cMethod instanceof CBinaryMethod))) {
            return super.hasSameSignature(cMethod);
        }
        CType[] cTypeArray2 = this.getParameters();
        if (cTypeArray2.length != (cTypeArray = cMethod.getParameters()).length + 1) {
            return false;
        }
        int n = 0;
        while (n < cTypeArray.length) {
            if (!cTypeArray2[n + 1].equals(cTypeArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String toString() {
        CClass cClass = this.getOwner();
        if (!(this.isConstructor() && cClass.isNested() && cClass.hasOuterThis())) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        CType[] cTypeArray = this.getParameters();
        stringBuffer.append(this.getReturnType());
        stringBuffer.append(" ");
        stringBuffer.append(this.getOwner());
        stringBuffer.append(".");
        stringBuffer.append(this.getIdent());
        stringBuffer.append("(");
        int n = 1;
        while (n < cTypeArray.length) {
            if (n != 1) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(cTypeArray[n]);
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public CBinaryMethod(CClass cClass, MethodInfo methodInfo) {
        super(cClass, methodInfo.getModifiers(), methodInfo.getName(), CBinaryMethod.buildReturnType(methodInfo), CBinaryMethod.buildParameterTypes(methodInfo), CBinaryMethod.buildExceptionTypes(methodInfo), methodInfo.isDeprecated());
    }
}

