/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CNumericType;
import at.dms.kjc.CStdType;
import at.dms.kjc.CType;
import at.dms.kjc.CodeLabel;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.JBinaryExpression;
import at.dms.kjc.JBooleanLiteral;
import at.dms.kjc.JExpression;
import at.dms.kjc.JLiteral;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import at.dms.util.InconsistencyException;

public class JRelationalExpression
extends JBinaryExpression {
    protected final int oper;

    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        this.left = this.left.analyse(cExpressionContext);
        this.right = this.right.analyse(cExpressionContext);
        this.check(cExpressionContext, this.left.getType().isNumeric() && this.right.getType().isNumeric(), KjcMessages.RELATIONAL_TYPE, this.left.getType(), this.right.getType());
        this.type = CStdType.Boolean;
        CType cType = CNumericType.binaryPromote(this.left.getType(), this.right.getType());
        this.left = this.left.convertType(cType, cExpressionContext);
        this.right = this.right.convertType(cType, cExpressionContext);
        if (this.left.isConstant() && this.right.isConstant()) {
            return this.constantFolding();
        }
        return this;
    }

    public JExpression constantFolding() {
        boolean bl;
        switch (this.left.getType().getTypeID()) {
            case 5: {
                bl = this.compute(this.left.intValue(), this.right.intValue());
                break;
            }
            case 6: {
                bl = this.compute(this.left.longValue(), this.right.longValue());
                break;
            }
            case 7: {
                bl = this.compute(this.left.floatValue(), this.right.floatValue());
                break;
            }
            case 8: {
                bl = this.compute(this.left.doubleValue(), this.right.doubleValue());
                break;
            }
            default: {
                throw new InconsistencyException("unexpected type " + this.left.getType());
            }
        }
        return new JBooleanLiteral(this.getTokenReference(), bl);
    }

    public boolean compute(int n, int n2) {
        switch (this.oper) {
            case 14: {
                return n < n2;
            }
            case 15: {
                return n <= n2;
            }
            case 16: {
                return n > n2;
            }
            case 17: {
                return n >= n2;
            }
        }
        throw new InconsistencyException();
    }

    public boolean compute(long l, long l2) {
        switch (this.oper) {
            case 14: {
                return l < l2;
            }
            case 15: {
                return l <= l2;
            }
            case 16: {
                return l > l2;
            }
            case 17: {
                return l >= l2;
            }
        }
        throw new InconsistencyException();
    }

    public boolean compute(float f, float f2) {
        switch (this.oper) {
            case 14: {
                return f < f2;
            }
            case 15: {
                return f <= f2;
            }
            case 16: {
                return f > f2;
            }
            case 17: {
                return f >= f2;
            }
        }
        throw new InconsistencyException();
    }

    public boolean compute(double d, double d2) {
        switch (this.oper) {
            case 14: {
                return d < d2;
            }
            case 15: {
                return d <= d2;
            }
            case 16: {
                return d > d2;
            }
            case 17: {
                return d >= d2;
            }
        }
        throw new InconsistencyException();
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitRelationalExpression(this, this.oper, this.left, this.right);
    }

    public void genCode(CodeSequence codeSequence, boolean bl) {
        this.genBooleanResultCode(codeSequence, bl);
    }

    protected void genBranch(JExpression jExpression, JExpression jExpression2, boolean bl, CodeSequence codeSequence, CodeLabel codeLabel) {
        this.setLineNumber(codeSequence);
        if (jExpression.getType() == CStdType.Integer && jExpression.isConstant() && ((JLiteral)jExpression).isDefault()) {
            int n;
            jExpression2.genCode(codeSequence, false);
            switch (this.oper) {
                case 14: {
                    n = bl ? 157 : 158;
                    break;
                }
                case 15: {
                    n = bl ? 156 : 155;
                    break;
                }
                case 16: {
                    n = bl ? 155 : 156;
                    break;
                }
                case 17: {
                    n = bl ? 158 : 157;
                    break;
                }
                default: {
                    throw new InconsistencyException("bad operator " + this.oper);
                }
            }
            codeSequence.plantJumpInstruction(n, codeLabel);
        } else if (jExpression.getType() == CStdType.Integer && jExpression2.isConstant() && ((JLiteral)jExpression2).isDefault()) {
            int n;
            jExpression.genCode(codeSequence, false);
            switch (this.oper) {
                case 14: {
                    n = bl ? 155 : 156;
                    break;
                }
                case 15: {
                    n = bl ? 158 : 157;
                    break;
                }
                case 16: {
                    n = bl ? 157 : 158;
                    break;
                }
                case 17: {
                    n = bl ? 156 : 155;
                    break;
                }
                default: {
                    throw new InconsistencyException("bad operator " + this.oper);
                }
            }
            codeSequence.plantJumpInstruction(n, codeLabel);
        } else {
            jExpression.genCode(codeSequence, false);
            jExpression2.genCode(codeSequence, false);
            if (jExpression.getType() == CStdType.Integer) {
                int n;
                switch (this.oper) {
                    case 14: {
                        n = bl ? 161 : 162;
                        break;
                    }
                    case 15: {
                        n = bl ? 164 : 163;
                        break;
                    }
                    case 16: {
                        n = bl ? 163 : 164;
                        break;
                    }
                    case 17: {
                        n = bl ? 162 : 161;
                        break;
                    }
                    default: {
                        throw new InconsistencyException("bad operator " + this.oper);
                    }
                }
                codeSequence.plantJumpInstruction(n, codeLabel);
            } else {
                int n;
                if (jExpression.getType() == CStdType.Long) {
                    n = 148;
                } else if (jExpression.getType() == CStdType.Float) {
                    n = 149;
                } else if (jExpression.getType() == CStdType.Double) {
                    n = 151;
                } else {
                    throw new InconsistencyException("bad type " + jExpression.getType());
                }
                codeSequence.plantNoArgInstruction(n);
                switch (this.oper) {
                    case 14: {
                        n = bl ? 155 : 156;
                        break;
                    }
                    case 15: {
                        n = bl ? 158 : 157;
                        break;
                    }
                    case 16: {
                        n = bl ? 157 : 158;
                        break;
                    }
                    case 17: {
                        n = bl ? 156 : 155;
                        break;
                    }
                    default: {
                        throw new InconsistencyException("bad operator " + this.oper);
                    }
                }
                codeSequence.plantJumpInstruction(n, codeLabel);
            }
        }
    }

    public JRelationalExpression(TokenReference tokenReference, int n, JExpression jExpression, JExpression jExpression2) {
        super(tokenReference, jExpression, jExpression2);
        this.oper = n;
    }
}

