/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.AsciiConstant;
import at.dms.classfile.ClassFileFormatException;
import at.dms.classfile.CodeInfo;
import at.dms.classfile.ConstantPool;
import at.dms.classfile.ConstantValueAttribute;
import at.dms.classfile.ConstraintsAttribute;
import at.dms.classfile.DeprecatedAttribute;
import at.dms.classfile.ExceptionsAttribute;
import at.dms.classfile.GenericAttribute;
import at.dms.classfile.InnerClassTable;
import at.dms.classfile.Instruction;
import at.dms.classfile.InvariantAttribute;
import at.dms.classfile.LineNumberTable;
import at.dms.classfile.LocalVariableTable;
import at.dms.classfile.PostconditionAttribute;
import at.dms.classfile.PreconditionAttribute;
import at.dms.classfile.SignatureAttribute;
import at.dms.classfile.SkippedCodeInfo;
import at.dms.classfile.SourceFileAttribute;
import at.dms.classfile.SyntheticAttribute;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class Attribute {
    public static final Attribute[] EMPTY = new Attribute[0];

    public static Attribute read(DataInput dataInput, ConstantPool constantPool) throws IOException, ClassFileFormatException {
        AsciiConstant asciiConstant = (AsciiConstant)constantPool.getEntryAt(dataInput.readUnsignedShort());
        String string = asciiConstant.getValue();
        switch (string.charAt(0)) {
            case 'C': {
                if (string.equals("Code")) {
                    return new CodeInfo(dataInput, constantPool);
                }
                if (string.equals("ConstantValue")) {
                    return new ConstantValueAttribute(dataInput, constantPool);
                }
                if (!string.equals("Constraints")) break;
                return new ConstraintsAttribute(dataInput, constantPool);
            }
            case 'D': {
                if (!string.equals("Deprecated")) break;
                return new DeprecatedAttribute(dataInput, constantPool);
            }
            case 'E': {
                if (!string.equals("Exceptions")) break;
                return new ExceptionsAttribute(dataInput, constantPool);
            }
            case 'I': {
                if (string.equals("InnerClasses")) {
                    return new InnerClassTable(dataInput, constantPool);
                }
                if (!string.equals("Invariant")) break;
                return new InvariantAttribute(dataInput, constantPool);
            }
            case 'L': {
                if (string.equals("LineNumberTable")) {
                    throw new ClassFileFormatException("Attribute \"LineNumberTable\" illegal outside of Attribute Code");
                }
                if (!string.equals("LocalVariableTable")) break;
                throw new ClassFileFormatException("Attribute \"LocalVariableTable\" illegal outside of Attribute Code");
            }
            case 'P': {
                if (string.equals("Postcondition")) {
                    return new PostconditionAttribute(dataInput, constantPool);
                }
                if (string.equals("Precondition")) {
                    return new PreconditionAttribute(dataInput, constantPool);
                }
            }
            case 'S': {
                if (string.equals("SourceFile")) {
                    return new SourceFileAttribute(dataInput, constantPool);
                }
                if (string.equals("Synthetic")) {
                    return new SyntheticAttribute(dataInput, constantPool);
                }
                if (!string.equals("Signature")) break;
                return new SignatureAttribute(dataInput, constantPool);
            }
        }
        return new GenericAttribute(asciiConstant, dataInput, constantPool);
    }

    public static Attribute readInterfaceOnly(DataInput dataInput, ConstantPool constantPool) throws IOException, ClassFileFormatException {
        AsciiConstant asciiConstant = (AsciiConstant)constantPool.getEntryAt(dataInput.readUnsignedShort());
        String string = asciiConstant.getValue();
        switch (string.charAt(0)) {
            case 'C': {
                if (string.equals("Code")) {
                    return new SkippedCodeInfo(dataInput, constantPool);
                }
                if (!string.equals("ConstantValue")) break;
                return new ConstantValueAttribute(dataInput, constantPool);
            }
            case 'D': {
                if (!string.equals("Deprecated")) break;
                return new DeprecatedAttribute(dataInput, constantPool);
            }
            case 'E': {
                if (!string.equals("Exceptions")) break;
                return new ExceptionsAttribute(dataInput, constantPool);
            }
            case 'I': {
                if (!string.equals("InnerClasses")) break;
                return new InnerClassTable(dataInput, constantPool);
            }
            case 'L': {
                if (string.equals("LineNumberTable")) {
                    throw new ClassFileFormatException("Attribute \"LineNumberTable\" illegal outside of Attribute Code");
                }
                if (!string.equals("LocalVariableTable")) break;
                throw new ClassFileFormatException("Attribute \"LocalVariableTable\" illegal outside of Attribute Code");
            }
            case 'S': {
                if (string.equals("SourceFile")) {
                    return new SourceFileAttribute(dataInput, constantPool);
                }
                if (!string.equals("Synthetic")) break;
                return new SyntheticAttribute(dataInput, constantPool);
            }
        }
        return new GenericAttribute(asciiConstant, dataInput, constantPool);
    }

    public static Attribute readCodeInfoAttribute(DataInput dataInput, ConstantPool constantPool, Instruction[] instructionArray) throws IOException, ClassFileFormatException {
        AsciiConstant asciiConstant = (AsciiConstant)constantPool.getEntryAt(dataInput.readUnsignedShort());
        String string = asciiConstant.getValue();
        switch (string.charAt(0)) {
            case 'C': {
                if (string.equals("Code")) {
                    throw new ClassFileFormatException("Attribute \"Code\" illegal as sub-attribute of Attribute Code");
                }
                if (!string.equals("ConstantValue")) break;
                throw new ClassFileFormatException("Attribute \"ConstantValue\" illegal as sub-attribute of Attribute Code");
            }
            case 'D': {
                if (!string.equals("Deprecated")) break;
                throw new ClassFileFormatException("Attribute \"Deprecated\" illegal as sub-attribute of Attribute Code");
            }
            case 'E': {
                if (!string.equals("Exceptions")) break;
                throw new ClassFileFormatException("Attribute \"Exceptions\" illegal as sub-attribute of Attribute Code");
            }
            case 'I': {
                if (!string.equals("InnerClasses")) break;
                throw new ClassFileFormatException("Attribute \"InnerClasses\" illegal as sub-attribute of Attribute Code");
            }
            case 'L': {
                if (string.equals("LineNumberTable")) {
                    return new LineNumberTable(dataInput, constantPool, instructionArray);
                }
                if (!string.equals("LocalVariableTable")) break;
                return new LocalVariableTable(dataInput, constantPool, instructionArray);
            }
            case 'S': {
                if (string.equals("SourceFile")) {
                    throw new ClassFileFormatException("Attribute \"SourceFile\" illegal as sub-attribute of Attribute Code");
                }
                if (!string.equals("Synthetic")) break;
                throw new ClassFileFormatException("Attribute \"Synthetic\" illegal as sub-attribute of Attribute Code");
            }
        }
        return new GenericAttribute(asciiConstant, dataInput, constantPool);
    }

    abstract int getTag();

    abstract int getSize();

    abstract void resolveConstants(ConstantPool var1) throws ClassFileFormatException;

    abstract void write(ConstantPool var1, DataOutput var2) throws IOException, ClassFileFormatException;
}

