/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.Attribute;
import at.dms.classfile.AttributeList;
import at.dms.classfile.ClassConstant;
import at.dms.classfile.ClassFileFormatException;
import at.dms.classfile.ConstantPool;
import at.dms.classfile.DeprecatedAttribute;
import at.dms.classfile.FieldInfo;
import at.dms.classfile.InnerClassInfo;
import at.dms.classfile.InnerClassTable;
import at.dms.classfile.Member;
import at.dms.classfile.MethodInfo;
import at.dms.classfile.SignatureAttribute;
import at.dms.classfile.SourceFileAttribute;
import at.dms.classfile.SyntheticAttribute;
import at.dms.util.InconsistencyException;
import at.dms.util.Utils;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;

public class ClassInfo
extends Member {
    private static final int MODIFIER_MASK = 1585;
    private String sourceDir;
    private int majorVersion;
    private int minorVersion;
    private ClassConstant thisClass;
    private ClassConstant superClass;
    private ClassConstant[] interfaces;
    private FieldInfo[] fields;
    private MethodInfo[] methods;
    private AttributeList attributes;
    static /* synthetic */ Class class$at$dms$classfile$FieldInfo;
    static /* synthetic */ Class class$at$dms$classfile$MethodInfo;

    public String getName() {
        return this.thisClass.getName();
    }

    public void setName(String string) {
        this.thisClass = new ClassConstant(string);
    }

    public String getSignature() {
        return this.thisClass.getName();
    }

    public String getSuperClass() {
        return this.superClass == null ? null : this.superClass.getName();
    }

    public void setSuperClass(String string) {
        this.superClass = string == null ? null : new ClassConstant(string);
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(int n) {
        this.majorVersion = n;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinor(int n) {
        this.minorVersion = n;
    }

    public InnerClassInfo[] getInnerClasses() {
        Attribute attribute = this.attributes.get(21);
        return attribute == null ? null : ((InnerClassTable)attribute).getEntries();
    }

    public void setInnerClasses(InnerClassInfo[] innerClassInfoArray) {
        if (innerClassInfoArray != null) {
            this.attributes.add(new InnerClassTable(innerClassInfoArray));
        } else {
            this.attributes.remove(21);
        }
    }

    public String getSourceFile() {
        Attribute attribute = this.attributes.get(1);
        return attribute == null ? null : ((SourceFileAttribute)attribute).getValue();
    }

    public void setSourceFile(String string) {
        if (string != null) {
            this.attributes.add(new SourceFileAttribute(string));
        } else {
            this.attributes.remove(1);
        }
    }

    public boolean isDeprecated() {
        boolean bl = false;
        if (this.attributes.get(11) != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isSynthetic() {
        boolean bl = false;
        if (this.attributes.get(22) != null) {
            bl = true;
        }
        return bl;
    }

    public void setDeprecated(boolean bl) {
        if (bl) {
            this.attributes.add(new DeprecatedAttribute());
        } else {
            this.attributes.remove(11);
        }
    }

    public String[] getInterfaces() {
        String[] stringArray = new String[this.interfaces.length];
        int n = 0;
        while (n < this.interfaces.length) {
            stringArray[n] = this.interfaces[n].getName();
            ++n;
        }
        return stringArray;
    }

    public String getGenericSignature() {
        Attribute attribute = this.attributes.get(105);
        return attribute == null ? null : ((SignatureAttribute)attribute).getSignature();
    }

    public void setGenericSignature(String string) {
        this.attributes.add(new SignatureAttribute(string));
    }

    public void setInterfaces(String[] stringArray) {
        this.interfaces = new ClassConstant[stringArray.length];
        int n = 0;
        while (n < this.interfaces.length) {
            this.interfaces[n] = new ClassConstant(stringArray[n]);
            ++n;
        }
    }

    public FieldInfo[] getFields() {
        return this.fields;
    }

    public void setFields(FieldInfo[] fieldInfoArray) {
        this.fields = fieldInfoArray;
    }

    public MethodInfo[] getMethods() {
        return this.methods;
    }

    public void setMethods(MethodInfo[] methodInfoArray) {
        this.methods = methodInfoArray;
    }

    public void write(DataOutput dataOutput) throws IOException, ClassFileFormatException {
        ConstantPool constantPool = this.resolveConstants();
        dataOutput.writeInt(-889275714);
        dataOutput.writeShort(this.minorVersion);
        dataOutput.writeShort(this.majorVersion);
        constantPool.write(dataOutput);
        dataOutput.writeShort((this.getModifiers() | 0x20) & 0x631);
        dataOutput.writeShort(this.thisClass.getIndex());
        int n = 0;
        if (this.superClass != null) {
            n = this.superClass.getIndex();
        }
        dataOutput.writeShort(n);
        dataOutput.writeShort(this.interfaces.length);
        int n2 = 0;
        while (n2 < this.interfaces.length) {
            dataOutput.writeShort(this.interfaces[n2].getIndex());
            ++n2;
        }
        dataOutput.writeShort(this.fields.length);
        n2 = 0;
        while (n2 < this.fields.length) {
            this.fields[n2].write(constantPool, dataOutput);
            ++n2;
        }
        dataOutput.writeShort(this.methods.length);
        n2 = 0;
        while (n2 < this.methods.length) {
            this.methods[n2].write(constantPool, dataOutput);
            ++n2;
        }
        this.attributes.write(constantPool, dataOutput);
        constantPool.close();
    }

    public void write(String string) throws IOException, ClassFileFormatException {
        String[] stringArray = Utils.splitQualifiedName(this.getName());
        if (string == null || string.equals("")) {
            string = this.sourceDir;
        } else if (stringArray[0] != null && !stringArray[0].equals("")) {
            string = string + File.separator + stringArray[0].replace('/', File.separatorChar);
        }
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.isDirectory()) {
            throw new InconsistencyException("File " + string + " is not a directory.");
        }
        File file2 = new File(string, stringArray[1] + ".class");
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
        this.write(dataOutputStream);
        dataOutputStream.flush();
        dataOutputStream.close();
    }

    private final ConstantPool resolveConstants() throws ClassFileFormatException {
        ConstantPool constantPool = new ConstantPool();
        constantPool.addItem(this.thisClass);
        if (this.superClass != null) {
            constantPool.addItem(this.superClass);
        }
        int n = 0;
        while (n < this.interfaces.length) {
            constantPool.addItem(this.interfaces[n]);
            ++n;
        }
        n = 0;
        while (n < this.fields.length) {
            this.fields[n].resolveConstants(constantPool);
            ++n;
        }
        n = 0;
        while (n < this.methods.length) {
            this.methods[n].resolveConstants(constantPool);
            ++n;
        }
        this.attributes.resolveConstants(constantPool);
        return constantPool;
    }

    private static final ClassConstant[] makeInterfacesArray(Vector vector) {
        ClassConstant[] classConstantArray = new ClassConstant[vector.size()];
        int n = 0;
        while (n < classConstantArray.length) {
            classConstantArray[n] = new ClassConstant((String)vector.elementAt(n));
            ++n;
        }
        return classConstantArray;
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ClassInfo(short s, String string, String string2, ClassConstant[] classConstantArray, FieldInfo[] fieldInfoArray, MethodInfo[] methodInfoArray, InnerClassInfo[] innerClassInfoArray, String string3, String string4, String string5, boolean bl, boolean bl2) {
        super(s);
        this.minorVersion = 3;
        this.majorVersion = 45;
        this.thisClass = new ClassConstant(string);
        this.superClass = string2 != null ? new ClassConstant(string2) : null;
        this.fields = fieldInfoArray;
        this.methods = methodInfoArray;
        this.interfaces = classConstantArray;
        this.sourceDir = string3 == null || string3.equals("") ? "." : string3;
        this.attributes = new AttributeList(innerClassInfoArray != null ? new InnerClassTable(innerClassInfoArray) : null, string4 != null ? new SourceFileAttribute(string4) : null, string5 != null ? new SignatureAttribute(string5) : null, bl2 ? new SyntheticAttribute() : null);
        if (bl) {
            this.attributes.add(new DeprecatedAttribute());
        }
    }

    public ClassInfo(short s, String string, String string2, Vector vector, Vector vector2, Vector vector3, InnerClassInfo[] innerClassInfoArray, String string3, String string4, String string5, boolean bl, boolean bl2) {
        ClassConstant[] classConstantArray = ClassInfo.makeInterfacesArray(vector);
        Class clazz = class$at$dms$classfile$FieldInfo;
        if (clazz == null) {
            clazz = class$at$dms$classfile$FieldInfo = ClassInfo.class$("[Lat.dms.classfile.FieldInfo;", false);
        }
        FieldInfo[] fieldInfoArray = (FieldInfo[])Utils.toArray(vector2, clazz);
        Class clazz2 = class$at$dms$classfile$MethodInfo;
        if (clazz2 == null) {
            clazz2 = class$at$dms$classfile$MethodInfo = ClassInfo.class$("[Lat.dms.classfile.MethodInfo;", false);
        }
        this(s, string, string2, classConstantArray, fieldInfoArray, (MethodInfo[])Utils.toArray(vector3, clazz2), innerClassInfoArray, string3, string4, string5, bl, bl2);
    }

    public ClassInfo(DataInput dataInput, boolean bl) throws IOException, ClassFileFormatException {
        int n = dataInput.readInt();
        if (n != -889275714) {
            throw new ClassFileFormatException("Bad magic number: " + n);
        }
        this.minorVersion = dataInput.readUnsignedShort();
        this.majorVersion = dataInput.readUnsignedShort();
        ConstantPool constantPool = new ConstantPool(dataInput);
        this.setModifiers((short)dataInput.readUnsignedShort());
        this.thisClass = (ClassConstant)constantPool.getEntryAt(dataInput.readUnsignedShort());
        this.superClass = (ClassConstant)constantPool.getEntryAt(dataInput.readUnsignedShort());
        this.interfaces = new ClassConstant[dataInput.readUnsignedShort()];
        int n2 = 0;
        while (n2 < this.interfaces.length) {
            this.interfaces[n2] = (ClassConstant)constantPool.getEntryAt(dataInput.readUnsignedShort());
            ++n2;
        }
        this.fields = new FieldInfo[dataInput.readUnsignedShort()];
        n2 = 0;
        while (n2 < this.fields.length) {
            this.fields[n2] = new FieldInfo(dataInput, constantPool);
            ++n2;
        }
        this.methods = new MethodInfo[dataInput.readUnsignedShort()];
        n2 = 0;
        while (n2 < this.methods.length) {
            this.methods[n2] = new MethodInfo(dataInput, constantPool, bl);
            ++n2;
        }
        this.attributes = new AttributeList(dataInput, constantPool, false);
        constantPool.close();
        constantPool = null;
    }
}

