/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.AccessorContainer;
import at.dms.classfile.AccessorTransformer;
import at.dms.classfile.BadAccessorException;
import at.dms.classfile.ClassFileFormatException;
import at.dms.classfile.CodeInfo;
import at.dms.classfile.CodePosition;
import at.dms.classfile.HandleCreator;
import at.dms.classfile.HandlerInfo;
import at.dms.classfile.Instruction;
import at.dms.classfile.InstructionAccessor;
import at.dms.classfile.InstructionHandle;
import at.dms.util.InconsistencyException;

public final class CodeEnv {
    private final CodeInfo codeInfo;
    private InstructionHandle methodStart;

    public static final void check(CodeInfo codeInfo) throws ClassFileFormatException {
        CodeEnv codeEnv = new CodeEnv(codeInfo);
        codeEnv.installInstructionHandles();
        codeEnv.checkExecutionPaths();
        codeEnv.computeCodeLength();
        codeEnv.computeStackAndLocals();
        codeEnv.removeInstructionHandles();
    }

    private final void checkExecutionPaths() throws ClassFileFormatException {
        this.checkExecutionPath(this.methodStart, 0);
        HandlerInfo[] handlerInfoArray = this.codeInfo.getHandlers();
        int n = 0;
        while (n < handlerInfoArray.length) {
            this.checkExecutionPath((InstructionHandle)handlerInfoArray[n].getHandler(), 1);
            ++n;
        }
    }

    final void checkExecutionPath(InstructionHandle instructionHandle, int n) throws ClassFileFormatException {
        try {
            while (instructionHandle != null && instructionHandle.checkInstruction(this, n)) {
                n = instructionHandle.getStackHeight();
                instructionHandle = instructionHandle.getNext();
            }
        }
        catch (ClassFileFormatException classFileFormatException) {
            this.dumpCode();
            throw classFileFormatException;
        }
    }

    private final void computeCodeLength() {
        InstructionHandle instructionHandle;
        CodePosition codePosition;
        boolean bl = false;
        do {
            bl = true;
            codePosition = new CodePosition(0, 0);
            instructionHandle = this.methodStart;
            while (instructionHandle != null) {
                bl &= instructionHandle.setAddressAndAdvancePC(codePosition);
                instructionHandle = instructionHandle.getNext();
            }
        } while (!bl);
        instructionHandle = this.methodStart;
        while (instructionHandle != null) {
            instructionHandle.setAddress();
            instructionHandle = instructionHandle.getNext();
        }
        this.codeInfo.setCodeLength(codePosition.min);
    }

    private final void computeStackAndLocals() {
        int n = 0;
        int n2 = 0;
        InstructionHandle instructionHandle = this.methodStart;
        while (instructionHandle != null) {
            n = Math.max(n, instructionHandle.getStackHeight());
            n2 = Math.max(n2, instructionHandle.getLocalVar());
            instructionHandle = instructionHandle.getNext();
        }
        this.codeInfo.setMaxStack(n);
        this.codeInfo.setMaxLocals(n2 + 1);
    }

    private final void installInstructionHandles() {
        Instruction[] instructionArray = this.codeInfo.getInstructions();
        InstructionHandle[] instructionHandleArray = new InstructionHandle[instructionArray.length];
        int n = 0;
        while (n < instructionHandleArray.length) {
            instructionHandleArray[n] = new InstructionHandle(instructionArray[n], n == 0 ? null : instructionHandleArray[n - 1]);
            ++n;
        }
        try {
            this.codeInfo.transformAccessors(new HandleCreator(instructionArray, instructionHandleArray));
        }
        catch (BadAccessorException badAccessorException) {
            throw new InconsistencyException(badAccessorException.getMessage());
        }
        this.methodStart = instructionHandleArray[0];
    }

    private final void removeInstructionHandles() {
        try {
            AccessorTransformer accessorTransformer = new AccessorTransformer(this){
                final /* synthetic */ CodeEnv this$0;

                public final InstructionAccessor transform(InstructionAccessor instructionAccessor, AccessorContainer accessorContainer) {
                    return ((InstructionHandle)instructionAccessor).getInstruction();
                }
                {
                    this.this$0 = codeEnv;
                }
            };
            this.codeInfo.transformAccessors(accessorTransformer);
        }
        catch (BadAccessorException badAccessorException) {
            throw new InconsistencyException(badAccessorException.getMessage());
        }
    }

    final void dumpCode() {
        InstructionHandle instructionHandle = this.methodStart;
        while (instructionHandle != null) {
            instructionHandle.dump();
            instructionHandle = instructionHandle.getNext();
        }
    }

    private CodeEnv(CodeInfo codeInfo) {
        this.codeInfo = codeInfo;
    }
}

