/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.AsciiConstant;
import at.dms.classfile.Attribute;
import at.dms.classfile.ClassFileFormatException;
import at.dms.classfile.ConstantPool;
import at.dms.classfile.MethodDescription;
import at.dms.classfile.MethodRefConstant;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ConstraintsAttribute
extends Attribute {
    public static final String NAME = "Constraints";
    private static AsciiConstant attr = new AsciiConstant("Constraints");
    private MethodRefConstant precondition;
    private MethodRefConstant postcondition;

    int getTag() {
        return 104;
    }

    int getSize() {
        return 10;
    }

    public MethodDescription getPrecondition() {
        if (this.precondition == null) {
            return null;
        }
        return new MethodDescription(this.precondition.getTypeName(), this.precondition.getType(), this.precondition.getClassName());
    }

    public MethodDescription getPostcondition() {
        if (this.postcondition == null) {
            return null;
        }
        return new MethodDescription(this.postcondition.getTypeName(), this.postcondition.getType(), this.postcondition.getClassName());
    }

    void resolveConstants(ConstantPool constantPool) throws ClassFileFormatException {
        constantPool.addItem(attr);
        if (this.precondition != null) {
            constantPool.addItem(this.precondition);
        }
        if (this.postcondition != null) {
            constantPool.addItem(this.postcondition);
        }
    }

    void write(ConstantPool constantPool, DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(attr.getIndex());
        dataOutput.writeInt(4);
        int n = 0;
        if (this.precondition != null) {
            n = this.precondition.getIndex();
        }
        dataOutput.writeShort(n);
        int n2 = 0;
        if (this.postcondition != null) {
            n2 = this.postcondition.getIndex();
        }
        dataOutput.writeShort(n2);
    }

    public ConstraintsAttribute(MethodDescription methodDescription, MethodDescription methodDescription2) {
        this.precondition = methodDescription != null ? new MethodRefConstant(methodDescription.getName(), methodDescription.getType()) : null;
        this.postcondition = methodDescription2 != null ? new MethodRefConstant(methodDescription2.getName(), methodDescription2.getType()) : null;
    }

    public ConstraintsAttribute(DataInput dataInput, ConstantPool constantPool) throws IOException, ClassFileFormatException {
        if (dataInput.readInt() != 4) {
            throw new ClassFileFormatException("bad attribute length");
        }
        int n = dataInput.readUnsignedShort();
        int n2 = dataInput.readUnsignedShort();
        this.precondition = n == 0 ? null : (MethodRefConstant)constantPool.getEntryAt(n);
        this.postcondition = n2 == 0 ? null : (MethodRefConstant)constantPool.getEntryAt(n2);
    }
}

