/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.AsciiConstant;
import at.dms.classfile.Attribute;
import at.dms.classfile.ClassConstant;
import at.dms.classfile.ClassFileFormatException;
import at.dms.classfile.ConstantPool;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ExceptionsAttribute
extends Attribute {
    private static AsciiConstant attr = new AsciiConstant("Exceptions");
    private ClassConstant[] exceptions;

    int getTag() {
        return 4;
    }

    int getSize() {
        return 8 + 2 * this.exceptions.length;
    }

    String[] getExceptions() {
        String[] stringArray = new String[this.exceptions.length];
        int n = 0;
        while (n < this.exceptions.length) {
            stringArray[n] = this.exceptions[n].getName();
            ++n;
        }
        return stringArray;
    }

    void resolveConstants(ConstantPool constantPool) throws ClassFileFormatException {
        constantPool.addItem(attr);
        int n = 0;
        while (n < this.exceptions.length) {
            constantPool.addItem(this.exceptions[n]);
            ++n;
        }
    }

    void write(ConstantPool constantPool, DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(attr.getIndex());
        dataOutput.writeInt(this.exceptions.length * 2 + 2);
        dataOutput.writeShort(this.exceptions.length);
        int n = 0;
        while (n < this.exceptions.length) {
            dataOutput.writeShort(this.exceptions[n].getIndex());
            ++n;
        }
    }

    public ExceptionsAttribute(String[] stringArray) {
        this.exceptions = new ClassConstant[stringArray.length];
        int n = 0;
        while (n < this.exceptions.length) {
            this.exceptions[n] = new ClassConstant(stringArray[n]);
            ++n;
        }
    }

    public ExceptionsAttribute(DataInput dataInput, ConstantPool constantPool) throws IOException {
        dataInput.readInt();
        this.exceptions = new ClassConstant[dataInput.readUnsignedShort()];
        int n = 0;
        while (n < this.exceptions.length) {
            this.exceptions[n] = (ClassConstant)constantPool.getEntryAt(dataInput.readUnsignedShort());
            ++n;
        }
    }
}

