/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.AsciiConstant;
import at.dms.classfile.Attribute;
import at.dms.classfile.ClassFileFormatException;
import at.dms.classfile.ConstantPool;
import at.dms.classfile.InnerClassInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class InnerClassTable
extends Attribute {
    private static AsciiConstant attr = new AsciiConstant("InnerClasses");
    private InnerClassInfo[] entries;

    int getTag() {
        return 21;
    }

    int getSize() {
        return 8 + 8 * this.entries.length;
    }

    InnerClassInfo[] getEntries() {
        return this.entries;
    }

    void resolveConstants(ConstantPool constantPool) throws ClassFileFormatException {
        constantPool.addItem(attr);
        int n = 0;
        while (n < this.entries.length) {
            this.entries[n].resolveConstants(constantPool);
            ++n;
        }
    }

    void write(ConstantPool constantPool, DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(attr.getIndex());
        dataOutput.writeInt(2 + 8 * this.entries.length);
        dataOutput.writeShort(this.entries.length);
        int n = 0;
        while (n < this.entries.length) {
            this.entries[n].write(constantPool, dataOutput);
            ++n;
        }
    }

    public InnerClassTable(InnerClassInfo[] innerClassInfoArray) {
        this.entries = innerClassInfoArray;
    }

    public InnerClassTable(DataInput dataInput, ConstantPool constantPool) throws IOException, ClassFileFormatException {
        dataInput.readInt();
        this.entries = new InnerClassInfo[dataInput.readUnsignedShort()];
        int n = 0;
        while (n < this.entries.length) {
            this.entries[n] = new InnerClassInfo(dataInput, constantPool);
            ++n;
        }
    }
}

