/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.AbstractInstructionAccessor;
import at.dms.classfile.ClassFileFormatException;
import at.dms.classfile.CodeEnv;
import at.dms.classfile.CodePosition;
import at.dms.classfile.ConstantPool;
import at.dms.classfile.Constants;
import at.dms.classfile.OpcodeNames;
import at.dms.util.InconsistencyException;
import java.io.DataOutput;
import java.io.IOException;

public abstract class Instruction
extends AbstractInstructionAccessor
implements Constants {
    private int opcode;
    private int address;

    public final int getOpcode() {
        return this.opcode;
    }

    final void setOpcode(int n) {
        this.opcode = n;
    }

    final int getAddress() {
        if (this.address == -1) {
            throw new InconsistencyException("instruction not reached");
        }
        return this.address;
    }

    final void setAddress(int n) {
        this.address = n;
    }

    abstract int getSize();

    int getLocalVar() {
        return 0;
    }

    void check(CodeEnv codeEnv, int n) throws ClassFileFormatException {
    }

    void computeEndAddress(CodePosition codePosition) {
        codePosition.addOffset(this.getSize());
    }

    public abstract byte getReturnType();

    public abstract int getStack();

    public abstract int getPushedOnStack();

    public final int getPoppedFromStack() {
        return Math.abs(this.getStack() - this.getPushedOnStack());
    }

    public boolean isLiteral() {
        return false;
    }

    public abstract boolean canComplete();

    abstract void resolveConstants(ConstantPool var1) throws ClassFileFormatException;

    abstract void write(ConstantPool var1, DataOutput var2) throws ClassFileFormatException, IOException;

    public void dump() {
        System.err.println(OpcodeNames.getName(this.getOpcode()) + " [" + this + ']');
    }

    public Instruction(int n) {
        this.opcode = n;
        this.address = -1;
    }
}

