/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.AbstractInstructionAccessor;
import at.dms.classfile.AccessorContainer;
import at.dms.classfile.ClassFileFormatException;
import at.dms.classfile.CodeEnv;
import at.dms.classfile.CodePosition;
import at.dms.classfile.Instruction;
import at.dms.classfile.OpcodeNames;

class InstructionHandle
extends AbstractInstructionAccessor {
    private final Instruction insn;
    private InstructionHandle next;
    private int index;
    private CodePosition position;
    private int stackHeight;

    public Instruction getInstruction() {
        return this.insn;
    }

    public InstructionHandle getNext() {
        return this.next;
    }

    public void attachTo(AccessorContainer accessorContainer) {
    }

    CodePosition getPosition() {
        return this.position;
    }

    final int getStackHeight() {
        return this.stackHeight;
    }

    final int getLocalVar() {
        return this.insn.getLocalVar();
    }

    final boolean checkInstruction(CodeEnv codeEnv, int n) throws ClassFileFormatException {
        if ((n += this.insn.getStack()) < 0) {
            System.err.println(">>>>>>>>" + n + " / " + this.insn.getStack());
            this.dump();
            throw new ClassFileFormatException("stack underflow");
        }
        if (this.stackHeight != Integer.MIN_VALUE) {
            if (this.stackHeight != n) {
                codeEnv.dumpCode();
                throw new ClassFileFormatException("@" + this.index + '(' + OpcodeNames.getName(this.insn.getOpcode()) + "): stack height different: " + this.stackHeight + '/' + n);
            }
            return false;
        }
        this.stackHeight = n;
        this.insn.check(codeEnv, n);
        return this.insn.canComplete();
    }

    boolean setAddressAndAdvancePC(CodePosition codePosition) {
        this.position.setPosition(codePosition);
        this.insn.computeEndAddress(codePosition);
        return codePosition.isFix();
    }

    void setAddress() {
        this.insn.setAddress(this.position.min);
    }

    void dump() {
        System.err.println(this.index + ":\t" + (this.stackHeight == Integer.MIN_VALUE ? "N/A" : "" + this.stackHeight) + '\t' + OpcodeNames.getName(this.insn.getOpcode()));
    }

    public InstructionHandle(Instruction instruction, InstructionHandle instructionHandle) {
        this.insn = instruction;
        this.next = null;
        if (instructionHandle == null) {
            this.index = 0;
        } else {
            this.index = instructionHandle.index + 1;
            instructionHandle.next = this;
        }
        this.position = new CodePosition(-1, -1);
        this.stackHeight = Integer.MIN_VALUE;
    }
}

