/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.AccessorContainer;
import at.dms.classfile.AccessorTransformer;
import at.dms.classfile.AsciiConstant;
import at.dms.classfile.BadAccessorException;
import at.dms.classfile.ClassFileFormatException;
import at.dms.classfile.ConstantPool;
import at.dms.classfile.Instruction;
import at.dms.classfile.InstructionAccessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LocalVariableInfo
implements AccessorContainer {
    private InstructionAccessor start;
    private InstructionAccessor end;
    private AsciiConstant name;
    private AsciiConstant type;
    private short slot;

    public void transformAccessors(AccessorTransformer accessorTransformer) throws BadAccessorException {
        this.start = this.start.transform(accessorTransformer, this);
        this.end = this.end.transform(accessorTransformer, this);
    }

    public String getName() {
        return this.name.getValue();
    }

    public String getType() {
        return this.type.getValue();
    }

    public void setStart(InstructionAccessor instructionAccessor) {
        this.start = instructionAccessor;
    }

    public InstructionAccessor getStart() {
        return this.start;
    }

    public void setEnd(InstructionAccessor instructionAccessor) {
        this.end = instructionAccessor;
    }

    public InstructionAccessor getEnd() {
        return this.end;
    }

    public short getSlot() {
        return this.slot;
    }

    void resolveConstants(ConstantPool constantPool) throws ClassFileFormatException {
        constantPool.addItem(this.name);
        constantPool.addItem(this.type);
    }

    void write(ConstantPool constantPool, DataOutput dataOutput) throws IOException {
        dataOutput.writeShort((short)((Instruction)this.start).getAddress());
        dataOutput.writeShort((short)(((Instruction)this.end).getAddress() + ((Instruction)this.end).getSize() - ((Instruction)this.start).getAddress()));
        dataOutput.writeShort(this.name.getIndex());
        dataOutput.writeShort(this.type.getIndex());
        dataOutput.writeShort(this.slot);
    }

    public LocalVariableInfo(InstructionAccessor instructionAccessor, InstructionAccessor instructionAccessor2, String string, String string2, short s) {
        this.start = instructionAccessor;
        this.end = instructionAccessor2;
        this.name = new AsciiConstant(string);
        this.type = new AsciiConstant(string2);
        this.slot = s;
    }

    public LocalVariableInfo(DataInput dataInput, ConstantPool constantPool, Instruction[] instructionArray) throws IOException {
        int n = dataInput.readUnsignedShort();
        int n2 = dataInput.readUnsignedShort();
        this.start = instructionArray[n];
        int n3 = n + n2 - 1;
        while (instructionArray[n3] == null) {
            --n3;
        }
        this.end = instructionArray[n3];
        this.name = (AsciiConstant)constantPool.getEntryAt(dataInput.readUnsignedShort());
        this.type = (AsciiConstant)constantPool.getEntryAt(dataInput.readUnsignedShort());
        this.slot = (short)dataInput.readUnsignedShort();
    }
}

