/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.AsciiConstant;
import at.dms.classfile.Attribute;
import at.dms.classfile.AttributeList;
import at.dms.classfile.ClassFileFormatException;
import at.dms.classfile.CodeInfo;
import at.dms.classfile.ConstantPool;
import at.dms.classfile.ConstraintsAttribute;
import at.dms.classfile.DeprecatedAttribute;
import at.dms.classfile.ExceptionsAttribute;
import at.dms.classfile.InstructionOverflowException;
import at.dms.classfile.InvariantAttribute;
import at.dms.classfile.LocalVariableOverflowException;
import at.dms.classfile.Member;
import at.dms.classfile.MethodDescription;
import at.dms.classfile.PostconditionAttribute;
import at.dms.classfile.PreconditionAttribute;
import at.dms.classfile.SignatureAttribute;
import at.dms.classfile.SyntheticAttribute;
import at.dms.util.InconsistencyException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MethodInfo
extends Member {
    private static final int MODIFIER_MASK = 3391;
    private AsciiConstant name;
    private AsciiConstant type;
    private AttributeList attributes;

    public String getName() {
        return this.name.getValue();
    }

    public void setName(String string) {
        this.name = new AsciiConstant(string);
    }

    public String getSignature() {
        return this.type.getValue();
    }

    public void setSignature(String string) {
        this.type = new AsciiConstant(string);
    }

    public String getGenericSignature() {
        Attribute attribute = this.attributes.get(105);
        return attribute == null ? this.getSignature() : ((SignatureAttribute)attribute).getSignature();
    }

    public void setGenericSignature(String string) {
        this.attributes.add(new SignatureAttribute(string));
    }

    public String[] getExceptions() {
        Attribute attribute = this.attributes.get(4);
        return attribute == null ? null : ((ExceptionsAttribute)attribute).getExceptions();
    }

    public void setExceptions(String[] stringArray) {
        if (stringArray != null) {
            this.attributes.add(new ExceptionsAttribute(stringArray));
        } else {
            this.attributes.remove(4);
        }
    }

    public boolean isDeprecated() {
        boolean bl = false;
        if (this.attributes.get(11) != null) {
            bl = true;
        }
        return bl;
    }

    public void setDeprecated(boolean bl) {
        if (bl) {
            this.attributes.add(new DeprecatedAttribute());
        } else {
            this.attributes.remove(11);
        }
    }

    public boolean isSynthetic() {
        boolean bl = false;
        if (this.attributes.get(22) != null) {
            bl = true;
        }
        return bl;
    }

    public void setSynthetic(boolean bl) {
        if (bl) {
            this.attributes.add(new SyntheticAttribute());
        } else {
            this.attributes.remove(22);
        }
    }

    public boolean isInvariant() {
        boolean bl = false;
        if (this.attributes.get(101) != null) {
            bl = true;
        }
        return bl;
    }

    public void setInvariant(boolean bl) {
        if (bl) {
            this.attributes.add(new InvariantAttribute());
        } else {
            this.attributes.remove(101);
        }
    }

    public boolean isPrecondition() {
        boolean bl = false;
        if (this.attributes.get(102) != null) {
            bl = true;
        }
        return bl;
    }

    public void setPrecondition(boolean bl) {
        if (bl) {
            this.attributes.add(new PreconditionAttribute());
        } else {
            this.attributes.remove(102);
        }
    }

    public boolean isPostcondition() {
        boolean bl = false;
        if (this.attributes.get(103) != null) {
            bl = true;
        }
        return bl;
    }

    public String getOldValueStore() {
        Attribute attribute = this.attributes.get(103);
        return attribute == null ? null : ((PostconditionAttribute)attribute).getOldValueStore();
    }

    public void setPostcondition(String string) {
        if (string == null) {
            this.attributes.add(new PostconditionAttribute());
        } else {
            this.attributes.add(new PostconditionAttribute(string));
        }
    }

    public MethodDescription getPreconditionMethod() {
        Attribute attribute = this.attributes.get(104);
        if (attribute == null) {
            return null;
        }
        return ((ConstraintsAttribute)attribute).getPrecondition();
    }

    public MethodDescription getPostconditionMethod() {
        Attribute attribute = this.attributes.get(104);
        if (attribute == null) {
            return null;
        }
        return ((ConstraintsAttribute)attribute).getPostcondition();
    }

    public void setConditionMethods(MethodDescription methodDescription, MethodDescription methodDescription2) {
        this.attributes.add(new ConstraintsAttribute(methodDescription, methodDescription2));
    }

    public CodeInfo getCodeInfo() {
        Attribute attribute = this.attributes.get(3);
        return attribute == null ? null : (CodeInfo)attribute;
    }

    public void setCodeInfo(CodeInfo codeInfo) {
        if (codeInfo != null) {
            codeInfo.setParameterCount(this.getParameterCount());
            this.attributes.add(codeInfo);
        } else {
            this.attributes.remove(3);
        }
    }

    public void resolveConstants(ConstantPool constantPool) throws ClassFileFormatException {
        constantPool.addItem(this.name);
        constantPool.addItem(this.type);
        this.attributes.resolveConstants(constantPool);
    }

    public void write(ConstantPool constantPool, DataOutput dataOutput) throws IOException, ClassFileFormatException {
        try {
            dataOutput.writeShort(this.getModifiers() & 0xD3F);
            dataOutput.writeShort(this.name.getIndex());
            dataOutput.writeShort(this.type.getIndex());
            this.attributes.write(constantPool, dataOutput);
        }
        catch (InstructionOverflowException instructionOverflowException) {
            instructionOverflowException.setMethod(this.name.getValue() + this.getSignature());
            throw instructionOverflowException;
        }
        catch (LocalVariableOverflowException localVariableOverflowException) {
            localVariableOverflowException.setMethod(this.name.getValue() + this.getSignature());
            throw localVariableOverflowException;
        }
    }

    protected int getParameterCount() {
        String string = this.getSignature();
        int n = 0;
        if ((this.getModifiers() & 8) == 0) {
            ++n;
        }
        if (string.charAt(0) != '(') {
            throw new InconsistencyException("invalid signature " + string);
        }
        int n2 = 1;
        block7: while (true) {
            switch (string.charAt(n2++)) {
                case ')': {
                    break block7;
                }
                case '[': {
                    while (string.charAt(n2) == '[') {
                        ++n2;
                    }
                    if (string.charAt(n2) == 'L') {
                        while (string.charAt(n2) != ';') {
                            ++n2;
                        }
                    }
                    ++n2;
                    ++n;
                    break;
                }
                case 'L': {
                    while (string.charAt(n2) != ';') {
                        ++n2;
                    }
                    ++n2;
                    ++n;
                    break;
                }
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    ++n;
                    break;
                }
                case 'D': 
                case 'J': {
                    n += 2;
                    break;
                }
                default: {
                    throw new InconsistencyException("invalid signature " + string);
                }
            }
        }
        return n;
    }

    public MethodInfo(short s, String string, String string2, String string3, String[] stringArray, CodeInfo codeInfo, boolean bl, boolean bl2) {
        super(s);
        this.name = new AsciiConstant(string);
        this.type = new AsciiConstant(string2);
        if (codeInfo != null && codeInfo.getParameterCount() == -1) {
            codeInfo.setParameterCount(this.getParameterCount());
        }
        this.attributes = new AttributeList(codeInfo, stringArray != null && stringArray.length != 0 ? new ExceptionsAttribute(stringArray) : null, string3 != null ? new SignatureAttribute(string3) : null, bl2 ? new SyntheticAttribute() : null);
        if (bl) {
            this.attributes.add(new DeprecatedAttribute());
        }
    }

    public MethodInfo(DataInput dataInput, ConstantPool constantPool, boolean bl) throws IOException, ClassFileFormatException {
        this.setModifiers((short)dataInput.readUnsignedShort());
        this.name = (AsciiConstant)constantPool.getEntryAt(dataInput.readUnsignedShort());
        this.type = (AsciiConstant)constantPool.getEntryAt(dataInput.readUnsignedShort());
        this.attributes = new AttributeList(dataInput, constantPool, bl);
        CodeInfo codeInfo = this.getCodeInfo();
        if (codeInfo != null && codeInfo.getParameterCount() == -1) {
            codeInfo.setParameterCount(this.getParameterCount());
        }
    }
}

