/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.ClassFileFormatException;
import at.dms.classfile.ConstantPool;
import at.dms.classfile.Instruction;
import at.dms.classfile.MethodRefConstant;
import at.dms.util.InconsistencyException;
import java.io.DataOutput;
import java.io.IOException;

public class MethodRefInstruction
extends Instruction {
    private MethodRefConstant method;

    public boolean canComplete() {
        return true;
    }

    void resolveConstants(ConstantPool constantPool) throws ClassFileFormatException {
        constantPool.addItem(this.method);
    }

    int getSize() {
        return 3;
    }

    public MethodRefConstant getMethodRefConstant() {
        return this.method;
    }

    public byte getReturnType() {
        String string = this.method.getType();
        switch (string.charAt(string.indexOf(")") + 1)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return 4;
            }
            case 'F': {
                return 3;
            }
            case 'L': 
            case '[': {
                return 6;
            }
            case 'D': {
                return 2;
            }
            case 'J': {
                return 5;
            }
        }
        throw new InconsistencyException("invalid signature " + string);
    }

    public int getPushedOnStack() {
        String string = this.method.getType();
        switch (string.charAt(string.indexOf(")") + 1)) {
            case 'V': {
                return 0;
            }
            case 'B': 
            case 'C': 
            case 'F': 
            case 'I': 
            case 'L': 
            case 'S': 
            case 'Z': 
            case '[': {
                return 1;
            }
            case 'D': 
            case 'J': {
                return 2;
            }
        }
        throw new InconsistencyException("invalid signature x" + string);
    }

    public int getStack() {
        String string = this.method.getType();
        int n = 0;
        if (string.charAt(0) != '(') {
            throw new InconsistencyException("invalid signature " + string);
        }
        int n2 = 1;
        block16: while (true) {
            switch (string.charAt(n2++)) {
                case ')': {
                    break block16;
                }
                case '[': {
                    while (string.charAt(n2) == '[') {
                        ++n2;
                    }
                    if (string.charAt(n2) == 'L') {
                        while (string.charAt(n2) != ';') {
                            ++n2;
                        }
                    }
                    ++n2;
                    --n;
                    break;
                }
                case 'L': {
                    while (string.charAt(n2) != ';') {
                        ++n2;
                    }
                    ++n2;
                    --n;
                    break;
                }
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    --n;
                    break;
                }
                case 'D': 
                case 'J': {
                    n -= 2;
                    break;
                }
                default: {
                    throw new InconsistencyException("invalid signature " + string);
                }
            }
        }
        switch (string.charAt(n2)) {
            case 'V': {
                break;
            }
            case 'B': 
            case 'C': 
            case 'F': 
            case 'I': 
            case 'L': 
            case 'S': 
            case 'Z': 
            case '[': {
                ++n;
                break;
            }
            case 'D': 
            case 'J': {
                n += 2;
                break;
            }
            default: {
                throw new InconsistencyException("invalid signature x" + string);
            }
        }
        switch (this.getOpcode()) {
            case 182: 
            case 183: {
                return n - 1;
            }
            case 184: {
                return n;
            }
        }
        throw new InconsistencyException("invalid opcode: " + this.getOpcode());
    }

    void write(ConstantPool constantPool, DataOutput dataOutput) throws IOException {
        dataOutput.writeByte((byte)this.getOpcode());
        dataOutput.writeShort(this.method.getIndex());
    }

    public MethodRefInstruction(int n, String string, String string2) {
        super(n);
        this.method = new MethodRefConstant(string, string2);
    }

    public MethodRefInstruction(int n, String string, String string2, String string3) {
        super(n);
        this.method = new MethodRefConstant(string, string2, string3);
    }

    public MethodRefInstruction(int n, MethodRefConstant methodRefConstant) {
        super(n);
        this.method = methodRefConstant;
    }
}

